/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.events;

import com.google.gerrit.extensions.events.GitReferenceUpdatedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitReferenceUpdated {
    private static final Logger log = LoggerFactory.getLogger(GitReferenceUpdated.class);
    public static final GitReferenceUpdated DISABLED = new GitReferenceUpdated(Collections.emptyList());
    private final Iterable<GitReferenceUpdatedListener> listeners;

    @Inject
    GitReferenceUpdated(DynamicSet<GitReferenceUpdatedListener> listeners) {
        this.listeners = listeners;
    }

    GitReferenceUpdated(Iterable<GitReferenceUpdatedListener> listeners) {
        this.listeners = listeners;
    }

    public void fire(Project.NameKey project, RefUpdate refUpdate) {
        this.fire(project, refUpdate.getName(), refUpdate.getOldObjectId(), refUpdate.getNewObjectId());
    }

    public void fire(Project.NameKey project, String ref, ObjectId oldObjectId, ObjectId newObjectId) {
        ObjectId o = oldObjectId != null ? oldObjectId : ObjectId.zeroId();
        ObjectId n = newObjectId != null ? newObjectId : ObjectId.zeroId();
        Event event = new Event(project, ref, o.name(), n.name());
        for (GitReferenceUpdatedListener l : this.listeners) {
            try {
                l.onGitReferenceUpdated(event);
            }
            catch (RuntimeException e) {
                log.warn("Failure in GitReferenceUpdatedListener", e);
            }
        }
    }

    private static class Event
    implements GitReferenceUpdatedListener.Event {
        private final String projectName;
        private final String ref;
        private final String oldObjectId;
        private final String newObjectId;

        Event(Project.NameKey project, String ref, String oldObjectId, String newObjectId) {
            this.projectName = project.get();
            this.ref = ref;
            this.oldObjectId = oldObjectId;
            this.newObjectId = newObjectId;
        }

        @Override
        public String getProjectName() {
            return this.projectName;
        }

        @Override
        public String getRefName() {
            return this.ref;
        }

        @Override
        public String getOldObjectId() {
            return this.oldObjectId;
        }

        @Override
        public String getNewObjectId() {
            return this.newObjectId;
        }
    }
}

