/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gerrit.extensions.events.GitReferenceUpdatedListener;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ChangeCache
implements GitReferenceUpdatedListener {
    private static final Logger log = LoggerFactory.getLogger(ChangeCache.class);
    private static final String ID_CACHE = "changes";
    private final LoadingCache<Project.NameKey, List<Change>> cache;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(ChangeCache.ID_CACHE, Project.NameKey.class, new TypeLiteral<List<Change>>(){}).maximumWeight(0L).loader(Loader.class);
            }
        };
    }

    @Inject
    ChangeCache(@Named(value="changes") LoadingCache<Project.NameKey, List<Change>> cache) {
        this.cache = cache;
    }

    List<Change> get(Project.NameKey name) {
        try {
            return this.cache.get(name);
        }
        catch (ExecutionException e) {
            log.warn("Cannot fetch changes for " + name, e);
            return Collections.emptyList();
        }
    }

    @Override
    public void onGitReferenceUpdated(GitReferenceUpdatedListener.Event event) {
        if (event.getRefName().startsWith("refs/changes/")) {
            this.cache.invalidate(new Project.NameKey(event.getProjectName()));
        }
    }

    static class Loader
    extends CacheLoader<Project.NameKey, List<Change>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        Loader(SchemaFactory<ReviewDb> schema) {
            this.schema = schema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Change> load(Project.NameKey key) throws Exception {
            try (ReviewDb db = this.schema.open();){
                List<Change> list = Collections.unmodifiableList(db.changes().byProject(key).toList());
                return list;
            }
        }
    }
}

