/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.Project;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

@Singleton
public class GarbageCollectionQueue {
    private final Set<Project.NameKey> projectsScheduledForGc = Sets.newHashSet();

    public synchronized Set<Project.NameKey> addAll(Collection<Project.NameKey> projects) {
        LinkedHashSet<Project.NameKey> added = Sets.newLinkedHashSetWithExpectedSize(projects.size());
        for (Project.NameKey p : projects) {
            if (!this.projectsScheduledForGc.add(p)) continue;
            added.add(p);
        }
        return added;
    }

    public synchronized void gcFinished(Project.NameKey project) {
        this.projectsScheduledForGc.remove(project);
    }
}

