/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.CommitMergeStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;

public class RebaseSorter {
    private final RevWalk rw;
    private final RevFlag canMergeFlag;
    private final Set<RevCommit> accepted;

    public RebaseSorter(RevWalk rw, Set<RevCommit> alreadyAccepted, RevFlag canMergeFlag) {
        this.rw = rw;
        this.canMergeFlag = canMergeFlag;
        this.accepted = alreadyAccepted;
    }

    public List<CodeReviewCommit> sort(Collection<CodeReviewCommit> incoming) throws IOException {
        ArrayList<CodeReviewCommit> sorted = new ArrayList<CodeReviewCommit>();
        HashSet<CodeReviewCommit> sort = new HashSet<CodeReviewCommit>(incoming);
        while (!sort.isEmpty()) {
            CodeReviewCommit c;
            CodeReviewCommit n = RebaseSorter.removeOne(sort);
            this.rw.resetRetain(this.canMergeFlag);
            this.rw.markStart(n);
            for (RevCommit c2 : this.accepted) {
                this.rw.markUninteresting(c2);
            }
            ArrayList<CodeReviewCommit> contents = new ArrayList<CodeReviewCommit>();
            while ((c = (CodeReviewCommit)this.rw.next()) != null) {
                if (!c.has(this.canMergeFlag) || !incoming.contains(c)) {
                    if (n.missing == null) {
                        n.setStatusCode(CommitMergeStatus.MISSING_DEPENDENCY);
                        n.missing = new ArrayList<CodeReviewCommit>();
                    }
                    n.missing.add(c);
                    continue;
                }
                contents.add(c);
            }
            if (n.getStatusCode() == CommitMergeStatus.MISSING_DEPENDENCY) continue;
            sort.removeAll(contents);
            Collections.reverse(contents);
            sorted.removeAll(contents);
            sorted.addAll(contents);
        }
        return sorted;
    }

    private static <T> T removeOne(Collection<T> c) {
        Iterator<T> i = c.iterator();
        T r = i.next();
        i.remove();
        return r;
    }
}

