/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.util.MagicBranch;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.BaseReceivePack;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveCommitsAdvertiseRefsHook
implements AdvertiseRefsHook {
    private static final Logger log = LoggerFactory.getLogger(ReceiveCommitsAdvertiseRefsHook.class);
    private final ReviewDb db;
    private final Project.NameKey projectName;

    public ReceiveCommitsAdvertiseRefsHook(ReviewDb db, Project.NameKey projectName) {
        this.db = db;
        this.projectName = projectName;
    }

    @Override
    public void advertiseRefs(UploadPack us) {
        throw new UnsupportedOperationException("ReceiveCommitsAdvertiseRefsHook cannot be used for UploadPack");
    }

    @Override
    public void advertiseRefs(BaseReceivePack rp) throws ServiceMayNotContinueException {
        Map<String, Ref> oldRefs = rp.getAdvertisedRefs();
        if (oldRefs == null) {
            try {
                oldRefs = rp.getRepository().getRefDatabase().getRefs("");
            }
            catch (ServiceMayNotContinueException e) {
                throw e;
            }
            catch (IOException e) {
                ServiceMayNotContinueException ex = new ServiceMayNotContinueException();
                ex.initCause(e);
                throw ex;
            }
        }
        HashMap<String, Ref> r = Maps.newHashMapWithExpectedSize(oldRefs.size());
        for (Map.Entry<String, Ref> e : oldRefs.entrySet()) {
            String name = e.getKey();
            if (ReceiveCommitsAdvertiseRefsHook.skip(name)) continue;
            r.put(name, e.getValue());
        }
        rp.setAdvertisedRefs(r, this.advertiseHistory(r.values(), rp));
    }

    private Set<ObjectId> advertiseHistory(Iterable<Ref> sending, BaseReceivePack rp) {
        HashSet<ObjectId> toInclude = Sets.newHashSet();
        try {
            HashSet<PatchSet.Id> toGet = Sets.newHashSetWithExpectedSize(32);
            for (Change c : this.db.changes().byProjectOpenNext(this.projectName, "z", 32)) {
                PatchSet.Id id = c.currentPatchSetId();
                if (id == null) continue;
                toGet.add(id);
            }
            for (PatchSet ps : this.db.patchSets().get(toGet)) {
                if (ps.getRevision() == null || ps.getRevision().get() == null) continue;
                toInclude.add(ObjectId.fromString(ps.getRevision().get()));
            }
        }
        catch (OrmException err) {
            log.error("Cannot list open changes of " + this.projectName, err);
        }
        int haveLineLen = 51;
        int maxExtraSize = 8192;
        int base = 64;
        int step = 16;
        int max = 160;
        HashSet<ObjectId> alreadySending = Sets.newHashSet();
        RevWalk rw = rp.getRevWalk();
        for (Ref ref : sending) {
            try {
                if (ref.getObjectId() == null) continue;
                alreadySending.add(ref.getObjectId());
                rw.markStart(rw.parseCommit(ref.getObjectId()));
            }
            catch (IOException badCommit) {}
        }
        int stepCnt = 0;
        try {
            RevCommit c;
            while ((c = rw.next()) != null && toInclude.size() < 160) {
                if (alreadySending.contains(c) || toInclude.contains(c) || c.getParentCount() > 1) continue;
                if (toInclude.size() < 64) {
                    toInclude.add(c);
                    continue;
                }
                ++stepCnt;
                if ((stepCnt %= 16) != 0) continue;
                toInclude.add(c);
            }
        }
        catch (IOException err) {
            log.error("Error trying to advertise history on " + this.projectName, err);
        }
        rw.reset();
        return toInclude;
    }

    private static boolean skip(String name) {
        return name.startsWith("refs/changes/") || name.startsWith("refs/cache-automerge/") || MagicBranch.isMagicBranch(name);
    }
}

