/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.ChangeUpdateExecutor;
import com.google.gerrit.server.git.EmailReviewCommentsExecutor;
import com.google.gerrit.server.git.ReceiveCommitsExecutor;
import com.google.gerrit.server.git.WorkQueue;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;

public class ReceiveCommitsExecutorModule
extends AbstractModule {
    @Override
    protected void configure() {
    }

    @Provides
    @Singleton
    @ReceiveCommitsExecutor
    public WorkQueue.Executor createReceiveCommitsExecutor(@GerritServerConfig Config config, WorkQueue queues) {
        int poolSize = config.getInt("receive", null, "threadPoolSize", Runtime.getRuntime().availableProcessors());
        return queues.createQueue(poolSize, "ReceiveCommits");
    }

    @Provides
    @Singleton
    @EmailReviewCommentsExecutor
    public WorkQueue.Executor createEmailReviewCommentsExecutor(@GerritServerConfig Config config, WorkQueue queues) {
        int poolSize = config.getInt("sendemail", null, "threadPoolSize", 1);
        return queues.createQueue(poolSize, "EmailReviewComments");
    }

    @Provides
    @Singleton
    @ChangeUpdateExecutor
    public ListeningExecutorService createChangeUpdateExecutor(@GerritServerConfig Config config) {
        int poolSize = config.getInt("receive", null, "changeUpdateThreads", 1);
        if (poolSize <= 1) {
            return MoreExecutors.sameThreadExecutor();
        }
        return MoreExecutors.listeningDecorator(MoreExecutors.getExitingExecutorService(new ThreadPoolExecutor(1, poolSize, 10L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(poolSize), new ThreadFactoryBuilder().setNameFormat("ChangeUpdate-%d").setDaemon(true).build(), new ThreadPoolExecutor.CallerRunsPolicy())));
    }
}

