/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.git.DefaultQueueOp;
import com.google.gerrit.server.git.MergeQueue;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadSubmitQueueOp
extends DefaultQueueOp {
    private static final Logger log = LoggerFactory.getLogger(ReloadSubmitQueueOp.class);
    private final SchemaFactory<ReviewDb> schema;
    private final MergeQueue mergeQueue;

    @Inject
    ReloadSubmitQueueOp(WorkQueue wq, SchemaFactory<ReviewDb> sf, MergeQueue mq) {
        super(wq);
        this.schema = sf;
        this.mergeQueue = mq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HashSet<Branch.NameKey> pending = new HashSet<Branch.NameKey>();
        try (ReviewDb c = this.schema.open();){
            for (Change change : c.changes().allSubmitted()) {
                pending.add(change.getDest());
            }
        }
        catch (OrmException e) {
            log.error("Cannot reload MergeQueue", e);
        }
        for (Branch.NameKey branch : pending) {
            this.mergeQueue.schedule(branch);
        }
    }

    public String toString() {
        return "Reload Submit Queue";
    }

    public static interface Factory {
        public ReloadSubmitQueueOp create();
    }
}

