/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.cache.Cache;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.git.TagSet;
import com.google.gerrit.server.git.TagSetHolder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.jgit.lib.ObjectId;

@Singleton
public class TagCache {
    private static final String CACHE_NAME = "git_tags";
    private final Cache<String, EntryVal> cache;
    private final Object createLock = new Object();

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.persist(TagCache.CACHE_NAME, String.class, EntryVal.class);
                this.bind(TagCache.class);
            }
        };
    }

    @Inject
    TagCache(@Named(value="git_tags") Cache<String, EntryVal> cache) {
        this.cache = cache;
    }

    public void updateFastForward(Project.NameKey name, String refName, ObjectId oldValue, ObjectId newValue) {
        TagSet tags;
        TagSetHolder holder;
        EntryVal val = this.cache.getIfPresent(name.get());
        if (val != null && (holder = val.holder) != null && (tags = holder.getTagSet()) != null && tags.updateFastForward(refName, oldValue, newValue)) {
            this.cache.put(name.get(), val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TagSetHolder get(Project.NameKey name) {
        EntryVal val = this.cache.getIfPresent(name.get());
        if (val == null) {
            Object object = this.createLock;
            synchronized (object) {
                val = this.cache.getIfPresent(name.get());
                if (val == null) {
                    val = new EntryVal();
                    val.holder = new TagSetHolder(name);
                    this.cache.put(name.get(), val);
                }
            }
        }
        return val.holder;
    }

    void put(Project.NameKey name, TagSetHolder tags) {
        EntryVal val = new EntryVal();
        val.holder = tags;
        this.cache.put(name.get(), val);
    }

    static class EntryVal
    implements Serializable {
        static final long serialVersionUID = 1L;
        transient TagSetHolder holder;

        EntryVal() {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.holder = new TagSetHolder(new Project.NameKey(in.readUTF()));
            if (in.readBoolean()) {
                TagSet tags = new TagSet(this.holder.getProjectName());
                tags.readObject(in);
                this.holder.setTagSet(tags);
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            TagSet tags = this.holder.getTagSet();
            out.writeUTF(this.holder.getProjectName().get());
            out.writeBoolean(tags != null);
            if (tags != null) {
                tags.writeObject(out);
            }
        }
    }
}

