/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.TagSet;
import com.google.gerrit.server.git.TagSetHolder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

class TagMatcher {
    final BitSet mask = new BitSet();
    final List<Ref> newRefs = new ArrayList<Ref>();
    final List<LostRef> lostRefs = new ArrayList<LostRef>();
    final TagSetHolder holder;
    final TagCache cache;
    final Repository db;
    final Collection<Ref> include;
    TagSet tags;
    final boolean updated;
    private boolean rebuiltForNewTags;

    TagMatcher(TagSetHolder holder, TagCache cache, Repository db, Collection<Ref> include, TagSet tags, boolean updated) {
        this.holder = holder;
        this.cache = cache;
        this.db = db;
        this.include = include;
        this.tags = tags;
        this.updated = updated;
    }

    boolean isReachable(Ref tagRef) {
        ObjectId tagObj = (tagRef = this.db.peel(tagRef)).getPeeledObjectId();
        if (tagObj == null && (tagObj = tagRef.getObjectId()) == null) {
            return false;
        }
        TagSet.Tag tag = this.tags.lookupTag(tagObj);
        if (tag == null) {
            if (this.rebuiltForNewTags) {
                return false;
            }
            this.rebuiltForNewTags = true;
            this.holder.rebuildForNewTags(this.cache, this);
            return this.isReachable(tagRef);
        }
        return tag.has(this.mask);
    }

    static class LostRef {
        final TagSet.Tag tag;
        final int flag;

        LostRef(TagSet.Tag tag, int flag) {
            this.tag = tag;
            this.flag = flag;
        }
    }
}

