/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.validators;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.config.ProjectConfigEntry;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.CommitMergeStatus;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.git.validators.MergeValidationException;
import com.google.gerrit.server.git.validators.MergeValidationListener;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

public class MergeValidators {
    private final DynamicSet<MergeValidationListener> mergeValidationListeners;
    private final ProjectConfigValidator.Factory projectConfigValidatorFactory;

    @Inject
    MergeValidators(DynamicSet<MergeValidationListener> mergeValidationListeners, ProjectConfigValidator.Factory projectConfigValidatorFactory) {
        this.mergeValidationListeners = mergeValidationListeners;
        this.projectConfigValidatorFactory = projectConfigValidatorFactory;
    }

    public void validatePreMerge(Repository repo, CodeReviewCommit commit, ProjectState destProject, Branch.NameKey destBranch, PatchSet.Id patchSetId) throws MergeValidationException {
        LinkedList<MergeValidationListener> validators = Lists.newLinkedList();
        validators.add(new PluginMergeValidationListener(this.mergeValidationListeners));
        validators.add(this.projectConfigValidatorFactory.create());
        for (MergeValidationListener validator : validators) {
            validator.onPreMerge(repo, commit, destProject, destBranch, patchSetId);
        }
    }

    public static class PluginMergeValidationListener
    implements MergeValidationListener {
        private final DynamicSet<MergeValidationListener> mergeValidationListeners;

        public PluginMergeValidationListener(DynamicSet<MergeValidationListener> mergeValidationListeners) {
            this.mergeValidationListeners = mergeValidationListeners;
        }

        @Override
        public void onPreMerge(Repository repo, CodeReviewCommit commit, ProjectState destProject, Branch.NameKey destBranch, PatchSet.Id patchSetId) throws MergeValidationException {
            for (MergeValidationListener validator : this.mergeValidationListeners) {
                validator.onPreMerge(repo, commit, destProject, destBranch, patchSetId);
            }
        }
    }

    public static class ProjectConfigValidator
    implements MergeValidationListener {
        private final AllProjectsName allProjectsName;
        private final ReviewDb db;
        private final ProjectCache projectCache;
        private final IdentifiedUser.GenericFactory identifiedUserFactory;
        private final ApprovalsUtil approvalsUtil;
        private final DynamicMap<ProjectConfigEntry> pluginConfigEntries;

        @Inject
        public ProjectConfigValidator(AllProjectsName allProjectsName, ReviewDb db, ProjectCache projectCache, IdentifiedUser.GenericFactory iuf, ApprovalsUtil approvalsUtil, DynamicMap<ProjectConfigEntry> pluginConfigEntries) {
            this.allProjectsName = allProjectsName;
            this.db = db;
            this.projectCache = projectCache;
            this.identifiedUserFactory = iuf;
            this.approvalsUtil = approvalsUtil;
            this.pluginConfigEntries = pluginConfigEntries;
        }

        @Override
        public void onPreMerge(Repository repo, CodeReviewCommit commit, ProjectState destProject, Branch.NameKey destBranch, PatchSet.Id patchSetId) throws MergeValidationException {
            if ("refs/meta/config".equals(destBranch.get())) {
                try {
                    ProjectConfig cfg = new ProjectConfig(destProject.getProject().getNameKey());
                    cfg.load(repo, (ObjectId)commit);
                    Project.NameKey newParent = cfg.getProject().getParent(this.allProjectsName);
                    Project.NameKey oldParent = destProject.getProject().getParent(this.allProjectsName);
                    if (oldParent == null) {
                        if (newParent != null) {
                            throw new MergeValidationException(CommitMergeStatus.INVALID_PROJECT_CONFIGURATION_ROOT_PROJECT_CANNOT_HAVE_PARENT);
                        }
                    } else if (!oldParent.equals(newParent)) {
                        PatchSetApproval psa = this.approvalsUtil.getSubmitter(this.db, commit.notes(), patchSetId);
                        if (psa == null) {
                            throw new MergeValidationException(CommitMergeStatus.SETTING_PARENT_PROJECT_ONLY_ALLOWED_BY_ADMIN);
                        }
                        IdentifiedUser identifiedUser = this.identifiedUserFactory.create(psa.getAccountId());
                        if (!identifiedUser.getCapabilities().canAdministrateServer()) {
                            throw new MergeValidationException(CommitMergeStatus.SETTING_PARENT_PROJECT_ONLY_ALLOWED_BY_ADMIN);
                        }
                        if (this.projectCache.get(newParent) == null) {
                            throw new MergeValidationException(CommitMergeStatus.INVALID_PROJECT_CONFIGURATION_PARENT_PROJECT_NOT_FOUND);
                        }
                    }
                    for (DynamicMap.Entry<ProjectConfigEntry> entry : this.pluginConfigEntries) {
                        PluginConfig pluginCfg = cfg.getPluginConfig(entry.getPluginName());
                        ProjectConfigEntry configEntry = entry.getProvider().get();
                        String value = pluginCfg.getString(entry.getExportName());
                        String oldValue = destProject.getConfig().getPluginConfig(entry.getPluginName()).getString(entry.getExportName());
                        if ((value == null ? oldValue != null : !value.equals(oldValue)) && !configEntry.isEditable(destProject)) {
                            throw new MergeValidationException(CommitMergeStatus.INVALID_PROJECT_CONFIGURATION_PLUGIN_VALUE_NOT_EDITABLE);
                        }
                        if (!ProjectConfigEntry.Type.LIST.equals((Object)configEntry.getType()) || value == null || configEntry.getPermittedValues().contains(value)) continue;
                        throw new MergeValidationException(CommitMergeStatus.INVALID_PROJECT_CONFIGURATION_PLUGIN_VALUE_NOT_PERMITTED);
                    }
                }
                catch (IOException | ConfigInvalidException e) {
                    throw new MergeValidationException(CommitMergeStatus.INVALID_PROJECT_CONFIGURATION);
                }
            }
        }

        public static interface Factory {
            public ProjectConfigValidator create();
        }
    }

    public static interface Factory {
        public MergeValidators create();
    }
}

