/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.client.AccountGroupByIdAud;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.account.GroupIncludeCache;
import com.google.gerrit.server.group.GetIncludedGroup;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.IncludedGroupResource;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class AddIncludedGroups
implements RestModifyView<GroupResource, Input> {
    private final Provider<GroupsCollection> groupsCollection;
    private final GroupIncludeCache groupIncludeCache;
    private final ReviewDb db;
    private final GroupJson json;

    @Inject
    public AddIncludedGroups(Provider<GroupsCollection> groupsCollection, GroupIncludeCache groupIncludeCache, ReviewDb db, GroupJson json) {
        this.groupsCollection = groupsCollection;
        this.groupIncludeCache = groupIncludeCache;
        this.db = db;
        this.json = json;
    }

    public List<GroupJson.GroupInfo> apply(GroupResource resource, Input input) throws MethodNotAllowedException, AuthException, UnprocessableEntityException, OrmException {
        AccountGroup group = resource.toAccountGroup();
        if (group == null) {
            throw new MethodNotAllowedException();
        }
        input = Input.init(input);
        GroupControl control = resource.getControl();
        HashMap<AccountGroup.UUID, AccountGroupById> newIncludedGroups = Maps.newHashMap();
        LinkedList<AccountGroupByIdAud> newIncludedGroupsAudits = Lists.newLinkedList();
        LinkedList<GroupJson.GroupInfo> result = Lists.newLinkedList();
        Account.Id me = ((IdentifiedUser)control.getCurrentUser()).getAccountId();
        for (String includedGroup : input.groups) {
            GroupDescription.Basic d = this.groupsCollection.get().parse(includedGroup);
            if (!control.canAddGroup(d.getGroupUUID())) {
                throw new AuthException(String.format("Cannot add group: %s", d.getName()));
            }
            if (!newIncludedGroups.containsKey(d.getGroupUUID())) {
                AccountGroupById.Key agiKey = new AccountGroupById.Key(group.getId(), d.getGroupUUID());
                AccountGroupById agi = this.db.accountGroupById().get(agiKey);
                if (agi == null) {
                    agi = new AccountGroupById(agiKey);
                    newIncludedGroups.put(d.getGroupUUID(), agi);
                    newIncludedGroupsAudits.add(new AccountGroupByIdAud(agi, me, TimeUtil.nowTs()));
                }
            }
            result.add(this.json.format(d));
        }
        if (!newIncludedGroups.isEmpty()) {
            this.db.accountGroupByIdAud().insert(newIncludedGroupsAudits);
            this.db.accountGroupById().insert(newIncludedGroups.values());
            for (AccountGroupById agi : newIncludedGroups.values()) {
                this.groupIncludeCache.evictMemberIn(agi.getIncludeUUID());
            }
            this.groupIncludeCache.evictMembersOf(group.getGroupUUID());
        }
        return result;
    }

    static class UpdateIncludedGroup
    implements RestModifyView<IncludedGroupResource, PutIncludedGroup.Input> {
        private final Provider<GetIncludedGroup> get;

        @Inject
        UpdateIncludedGroup(Provider<GetIncludedGroup> get) {
            this.get = get;
        }

        public GroupJson.GroupInfo apply(IncludedGroupResource resource, PutIncludedGroup.Input input) throws OrmException {
            return this.get.get().apply(resource);
        }

        static class Input {
            Input() {
            }
        }
    }

    static class PutIncludedGroup
    implements RestModifyView<GroupResource, Input> {
        private final Provider<AddIncludedGroups> put;
        private final String id;

        PutIncludedGroup(Provider<AddIncludedGroups> put, String id) {
            this.put = put;
            this.id = id;
        }

        public GroupJson.GroupInfo apply(GroupResource resource, Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, OrmException {
            com.google.gerrit.server.group.AddIncludedGroups$Input in = new com.google.gerrit.server.group.AddIncludedGroups$Input();
            in.groups = ImmutableList.of(this.id);
            List<GroupJson.GroupInfo> list = this.put.get().apply(resource, in);
            if (list.size() == 1) {
                return list.get(0);
            }
            throw new IllegalStateException();
        }

        static class Input {
            Input() {
            }
        }
    }

    public static class Input {
        @DefaultInput
        String _oneGroup;
        public List<String> groups;

        public static Input fromGroups(List<String> groups) {
            Input in = new Input();
            in.groups = groups;
            return in;
        }

        static Input init(Input in) {
            if (in == null) {
                in = new Input();
            }
            if (in.groups == null) {
                in.groups = Lists.newArrayListWithCapacity(1);
            }
            if (!Strings.isNullOrEmpty(in._oneGroup)) {
                in.groups.add(in._oneGroup);
            }
            return in;
        }
    }
}

