/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.common.errors.NameAlreadyUsedException;
import com.google.gerrit.common.errors.PermissionDeniedException;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.CreateGroupArgs;
import com.google.gerrit.server.account.PerformCreateGroup;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.validators.GroupCreationValidationListener;
import com.google.gerrit.server.validators.ValidationException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.util.Collections;
import org.eclipse.jgit.lib.Config;

@RequiresCapability(value="createGroup")
public class CreateGroup
implements RestModifyView<TopLevelResource, Input> {
    private final Provider<IdentifiedUser> self;
    private final GroupsCollection groups;
    private final PerformCreateGroup.Factory op;
    private final GroupJson json;
    private final DynamicSet<GroupCreationValidationListener> groupCreationValidationListeners;
    private final boolean defaultVisibleToAll;
    private final String name;

    @Inject
    CreateGroup(Provider<IdentifiedUser> self, GroupsCollection groups, PerformCreateGroup.Factory performCreateGroupFactory, GroupJson json, DynamicSet<GroupCreationValidationListener> groupCreationValidationListeners, @GerritServerConfig Config cfg, @Assisted String name) {
        this.self = self;
        this.groups = groups;
        this.op = performCreateGroupFactory;
        this.json = json;
        this.groupCreationValidationListeners = groupCreationValidationListeners;
        this.defaultVisibleToAll = cfg.getBoolean("groups", "newGroupsVisibleToAll", false);
        this.name = name;
    }

    public GroupJson.GroupInfo apply(TopLevelResource resource, Input input) throws AuthException, BadRequestException, UnprocessableEntityException, ResourceConflictException, OrmException {
        AccountGroup group;
        if (input == null) {
            input = new Input();
        }
        if (input.name != null && !this.name.equals(input.name)) {
            throw new BadRequestException("name must match URL");
        }
        AccountGroup.Id ownerId = this.owner(input);
        try {
            CreateGroupArgs args = new CreateGroupArgs();
            args.setGroupName(this.name);
            args.groupDescription = Strings.emptyToNull(input.description);
            args.visibleToAll = Objects.firstNonNull(input.visibleToAll, this.defaultVisibleToAll);
            args.ownerGroupId = ownerId;
            args.initialMembers = ownerId == null ? Collections.singleton(this.self.get().getAccountId()) : Collections.emptySet();
            for (GroupCreationValidationListener l : this.groupCreationValidationListeners) {
                try {
                    l.validateNewGroup(args);
                }
                catch (ValidationException e) {
                    throw new ResourceConflictException(e.getMessage(), e);
                }
            }
            group = this.op.create(args).createGroup();
        }
        catch (PermissionDeniedException e) {
            throw new AuthException(e.getMessage());
        }
        catch (NameAlreadyUsedException e) {
            throw new ResourceConflictException(e.getMessage());
        }
        return this.json.format(GroupDescriptions.forAccountGroup(group));
    }

    private AccountGroup.Id owner(Input input) throws UnprocessableEntityException {
        if (input.ownerId != null) {
            GroupDescription.Basic d = this.groups.parseInternal(Url.decode(input.ownerId));
            return GroupDescriptions.toAccountGroup(d).getId();
        }
        return null;
    }

    public static interface Factory {
        public CreateGroup create(@Assisted String var1);
    }

    public static class Input {
        public String name;
        public String description;
        public Boolean visibleToAll;
        public String ownerId;
    }
}

