/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.group.AddMembers;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.ListMembers;
import com.google.gerrit.server.group.MemberResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class MembersCollection
implements ChildCollection<GroupResource, MemberResource>,
AcceptsCreate<GroupResource> {
    private final DynamicMap<RestView<MemberResource>> views;
    private final Provider<ListMembers> list;
    private final Provider<AccountsCollection> accounts;
    private final Provider<ReviewDb> db;
    private final Provider<AddMembers> put;

    @Inject
    MembersCollection(DynamicMap<RestView<MemberResource>> views, Provider<ListMembers> list, Provider<AccountsCollection> accounts, Provider<ReviewDb> db, Provider<AddMembers> put) {
        this.views = views;
        this.list = list;
        this.accounts = accounts;
        this.db = db;
        this.put = put;
    }

    @Override
    public RestView<GroupResource> list() throws ResourceNotFoundException, AuthException {
        return this.list.get();
    }

    @Override
    public MemberResource parse(GroupResource parent, IdString id) throws MethodNotAllowedException, AuthException, ResourceNotFoundException, OrmException {
        if (parent.toAccountGroup() == null) {
            throw new MethodNotAllowedException();
        }
        IdentifiedUser user = this.accounts.get().parse(TopLevelResource.INSTANCE, id).getUser();
        AccountGroupMember.Key key = new AccountGroupMember.Key(user.getAccountId(), parent.toAccountGroup().getId());
        if (this.db.get().accountGroupMembers().get(key) != null && parent.getControl().canSeeMember(user.getAccountId())) {
            return new MemberResource(parent, user);
        }
        throw new ResourceNotFoundException(id);
    }

    public AddMembers.PutMember create(GroupResource group, IdString id) {
        return new AddMembers.PutMember(this.put, id.get());
    }

    @Override
    public DynamicMap<RestView<MemberResource>> views() {
        return this.views;
    }
}

