/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.RestApiModule;
import com.google.gerrit.server.group.AddIncludedGroups;
import com.google.gerrit.server.group.AddMembers;
import com.google.gerrit.server.group.CreateGroup;
import com.google.gerrit.server.group.DeleteIncludedGroups;
import com.google.gerrit.server.group.DeleteMembers;
import com.google.gerrit.server.group.GetDescription;
import com.google.gerrit.server.group.GetDetail;
import com.google.gerrit.server.group.GetGroup;
import com.google.gerrit.server.group.GetIncludedGroup;
import com.google.gerrit.server.group.GetMember;
import com.google.gerrit.server.group.GetName;
import com.google.gerrit.server.group.GetOptions;
import com.google.gerrit.server.group.GetOwner;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.IncludedGroupResource;
import com.google.gerrit.server.group.IncludedGroupsCollection;
import com.google.gerrit.server.group.MemberResource;
import com.google.gerrit.server.group.MembersCollection;
import com.google.gerrit.server.group.PutDescription;
import com.google.gerrit.server.group.PutGroup;
import com.google.gerrit.server.group.PutName;
import com.google.gerrit.server.group.PutOptions;
import com.google.gerrit.server.group.PutOwner;
import com.google.inject.assistedinject.FactoryModuleBuilder;

public class Module
extends RestApiModule {
    @Override
    protected void configure() {
        this.bind(GroupsCollection.class);
        DynamicMap.mapOf(this.binder(), GroupResource.GROUP_KIND);
        DynamicMap.mapOf(this.binder(), MemberResource.MEMBER_KIND);
        DynamicMap.mapOf(this.binder(), IncludedGroupResource.INCLUDED_GROUP_KIND);
        this.get(GroupResource.GROUP_KIND).to(GetGroup.class);
        this.put(GroupResource.GROUP_KIND).to(PutGroup.class);
        this.get(GroupResource.GROUP_KIND, "detail").to(GetDetail.class);
        this.post(GroupResource.GROUP_KIND, "members").to(AddMembers.class);
        this.post(GroupResource.GROUP_KIND, "members.add").to(AddMembers.class);
        this.post(GroupResource.GROUP_KIND, "members.delete").to(DeleteMembers.class);
        this.post(GroupResource.GROUP_KIND, "groups").to(AddIncludedGroups.class);
        this.post(GroupResource.GROUP_KIND, "groups.add").to(AddIncludedGroups.class);
        this.post(GroupResource.GROUP_KIND, "groups.delete").to(DeleteIncludedGroups.class);
        this.get(GroupResource.GROUP_KIND, "description").to(GetDescription.class);
        this.put(GroupResource.GROUP_KIND, "description").to(PutDescription.class);
        this.delete(GroupResource.GROUP_KIND, "description").to(PutDescription.class);
        this.get(GroupResource.GROUP_KIND, "name").to(GetName.class);
        this.put(GroupResource.GROUP_KIND, "name").to(PutName.class);
        this.get(GroupResource.GROUP_KIND, "owner").to(GetOwner.class);
        this.put(GroupResource.GROUP_KIND, "owner").to(PutOwner.class);
        this.get(GroupResource.GROUP_KIND, "options").to(GetOptions.class);
        this.put(GroupResource.GROUP_KIND, "options").to(PutOptions.class);
        this.child(GroupResource.GROUP_KIND, "members").to(MembersCollection.class);
        this.get(MemberResource.MEMBER_KIND).to(GetMember.class);
        this.put(MemberResource.MEMBER_KIND).to(AddMembers.UpdateMember.class);
        this.delete(MemberResource.MEMBER_KIND).to(DeleteMembers.DeleteMember.class);
        this.child(GroupResource.GROUP_KIND, "groups").to(IncludedGroupsCollection.class);
        this.get(IncludedGroupResource.INCLUDED_GROUP_KIND).to(GetIncludedGroup.class);
        this.put(IncludedGroupResource.INCLUDED_GROUP_KIND).to(AddIncludedGroups.UpdateIncludedGroup.class);
        this.delete(IncludedGroupResource.INCLUDED_GROUP_KIND).to(DeleteIncludedGroups.DeleteIncludedGroup.class);
        this.install(new FactoryModuleBuilder().build(CreateGroup.Factory.class));
    }
}

