/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.index.ChangeIndex;
import com.google.gerrit.server.index.IndexCollection;
import com.google.gerrit.server.index.IndexExecutor;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.util.Providers;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeIndexer {
    private static final Logger log = LoggerFactory.getLogger(ChangeIndexer.class);
    private static final Function<Exception, IOException> MAPPER = new Function<Exception, IOException>(){

        @Override
        public IOException apply(Exception in) {
            if (in instanceof IOException) {
                return (IOException)in;
            }
            if (in instanceof ExecutionException && in.getCause() instanceof IOException) {
                return (IOException)in.getCause();
            }
            return new IOException(in);
        }
    };
    private final IndexCollection indexes;
    private final ChangeIndex index;
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final ChangeData.Factory changeDataFactory;
    private final ThreadLocalRequestContext context;
    private final ListeningExecutorService executor;

    @AssistedInject
    ChangeIndexer(@IndexExecutor ListeningExecutorService executor, SchemaFactory<ReviewDb> schemaFactory, ChangeData.Factory changeDataFactory, ThreadLocalRequestContext context, @Assisted ChangeIndex index) {
        this.executor = executor;
        this.schemaFactory = schemaFactory;
        this.changeDataFactory = changeDataFactory;
        this.context = context;
        this.index = index;
        this.indexes = null;
    }

    @AssistedInject
    ChangeIndexer(@IndexExecutor ListeningExecutorService executor, SchemaFactory<ReviewDb> schemaFactory, ChangeData.Factory changeDataFactory, ThreadLocalRequestContext context, @Assisted IndexCollection indexes) {
        this.executor = executor;
        this.schemaFactory = schemaFactory;
        this.changeDataFactory = changeDataFactory;
        this.context = context;
        this.index = null;
        this.indexes = indexes;
    }

    public CheckedFuture<?, IOException> indexAsync(Change.Id id) {
        return this.executor != null ? this.submit(new Task(id, false)) : Futures.immediateCheckedFuture(null);
    }

    public void index(ChangeData cd) throws IOException {
        for (ChangeIndex i : this.getWriteIndexes()) {
            i.replace(cd);
        }
    }

    public void index(ReviewDb db, Change change) throws IOException {
        this.index(this.changeDataFactory.create(db, change));
    }

    public CheckedFuture<?, IOException> deleteAsync(Change.Id id) {
        return this.executor != null ? this.submit(new Task(id, true)) : Futures.immediateCheckedFuture(null);
    }

    public void delete(ChangeData cd) throws IOException {
        for (ChangeIndex i : this.getWriteIndexes()) {
            i.delete(cd);
        }
    }

    public void delete(ReviewDb db, Change change) throws IOException {
        this.delete(this.changeDataFactory.create(db, change));
    }

    private Collection<ChangeIndex> getWriteIndexes() {
        return this.indexes != null ? this.indexes.getWriteIndexes() : Collections.singleton(this.index);
    }

    private CheckedFuture<?, IOException> submit(Callable<?> task) {
        return Futures.makeChecked(this.executor.submit(task), MAPPER);
    }

    private class Task
    implements Callable<Void> {
        private final Change.Id id;
        private final boolean delete;

        private Task(Change.Id id, boolean delete) {
            this.id = id;
            this.delete = delete;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            Void void_;
            final AtomicReference dbRef = Atomics.newReference();
            RequestContext newCtx = new RequestContext(){

                @Override
                public Provider<ReviewDb> getReviewDbProvider() {
                    Provider db = (Provider)dbRef.get();
                    if (db == null) {
                        try {
                            db = Providers.of(ChangeIndexer.this.schemaFactory.open());
                        }
                        catch (OrmException e) {
                            ProvisionException pe = new ProvisionException("error opening ReviewDb");
                            pe.initCause(e);
                            throw pe;
                        }
                        dbRef.set(db);
                    }
                    return db;
                }

                @Override
                public CurrentUser getCurrentUser() {
                    throw new OutOfScopeException("No user during ChangeIndexer");
                }
            };
            RequestContext oldCtx = ChangeIndexer.this.context.setContext(newCtx);
            try {
                ChangeData cd = ChangeIndexer.this.changeDataFactory.create(newCtx.getReviewDbProvider().get(), this.id);
                if (this.delete) {
                    for (ChangeIndex i : ChangeIndexer.this.getWriteIndexes()) {
                        i.delete(cd);
                    }
                } else {
                    for (ChangeIndex i : ChangeIndexer.this.getWriteIndexes()) {
                        i.replace(cd);
                    }
                }
                void_ = null;
                ChangeIndexer.this.context.setContext(oldCtx);
            }
            catch (Throwable throwable) {
                try {
                    ChangeIndexer.this.context.setContext(oldCtx);
                    Provider db = (Provider)dbRef.get();
                    if (db != null) {
                        ((ReviewDb)db.get()).close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(String.format("Failed to index change %d", this.id.get()), e);
                    throw e;
                }
            }
            Provider db = (Provider)dbRef.get();
            if (db != null) {
                ((ReviewDb)db.get()).close();
            }
            return void_;
        }

        public String toString() {
            return "index-change-" + this.id.get();
        }
    }

    public static interface Factory {
        public ChangeIndexer create(ChangeIndex var1);

        public ChangeIndexer create(IndexCollection var1);
    }
}

