/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.FieldDef;
import com.google.gerrit.server.index.Schema;
import com.google.gerrit.server.query.change.ChangeData;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeMap;

public class ChangeSchemas {
    static final Schema<ChangeData> V1 = ChangeSchemas.release(ChangeField.LEGACY_ID, ChangeField.ID, ChangeField.STATUS, ChangeField.PROJECT, ChangeField.REF, ChangeField.TOPIC, ChangeField.LEGACY_UPDATED, ChangeField.LEGACY_SORTKEY, ChangeField.PATH, ChangeField.OWNER, ChangeField.REVIEWER, ChangeField.COMMIT, ChangeField.TR, ChangeField.LABEL, ChangeField.REVIEWED, ChangeField.COMMIT_MESSAGE, ChangeField.COMMENT);
    static final Schema<ChangeData> V2 = ChangeSchemas.release(ChangeField.LEGACY_ID, ChangeField.ID, ChangeField.STATUS, ChangeField.PROJECT, ChangeField.REF, ChangeField.TOPIC, ChangeField.LEGACY_UPDATED, ChangeField.LEGACY_SORTKEY, ChangeField.PATH, ChangeField.OWNER, ChangeField.REVIEWER, ChangeField.COMMIT, ChangeField.TR, ChangeField.LABEL, ChangeField.REVIEWED, ChangeField.COMMIT_MESSAGE, ChangeField.COMMENT, ChangeField.CHANGE, ChangeField.APPROVAL);
    static final Schema<ChangeData> V3 = ChangeSchemas.release(ChangeField.LEGACY_ID, ChangeField.ID, ChangeField.STATUS, ChangeField.PROJECT, ChangeField.REF, ChangeField.TOPIC, ChangeField.LEGACY_UPDATED, ChangeField.SORTKEY, ChangeField.PATH, ChangeField.OWNER, ChangeField.REVIEWER, ChangeField.COMMIT, ChangeField.TR, ChangeField.LABEL, ChangeField.REVIEWED, ChangeField.COMMIT_MESSAGE, ChangeField.COMMENT, ChangeField.CHANGE, ChangeField.APPROVAL);
    static final Schema<ChangeData> V4 = ChangeSchemas.release(V3.getFields().values());
    static final Schema<ChangeData> V5 = ChangeSchemas.release(ChangeField.LEGACY_ID, ChangeField.ID, ChangeField.STATUS, ChangeField.PROJECT, ChangeField.REF, ChangeField.TOPIC, ChangeField.LEGACY_UPDATED, ChangeField.SORTKEY, ChangeField.PATH, ChangeField.OWNER, ChangeField.REVIEWER, ChangeField.COMMIT, ChangeField.TR, ChangeField.LABEL, ChangeField.REVIEWED, ChangeField.COMMIT_MESSAGE, ChangeField.COMMENT, ChangeField.CHANGE, ChangeField.APPROVAL, ChangeField.MERGEABLE);
    static final Schema<ChangeData> V6 = ChangeSchemas.release(V5.getFields().values());
    static final Schema<ChangeData> V7 = ChangeSchemas.release(ChangeField.LEGACY_ID, ChangeField.ID, ChangeField.STATUS, ChangeField.PROJECT, ChangeField.REF, ChangeField.TOPIC, ChangeField.LEGACY_UPDATED, ChangeField.SORTKEY, ChangeField.FILE_PART, ChangeField.PATH, ChangeField.OWNER, ChangeField.REVIEWER, ChangeField.COMMIT, ChangeField.TR, ChangeField.LABEL, ChangeField.REVIEWED, ChangeField.COMMIT_MESSAGE, ChangeField.COMMENT, ChangeField.CHANGE, ChangeField.APPROVAL, ChangeField.MERGEABLE);
    static final Schema<ChangeData> V8 = ChangeSchemas.release(ChangeField.LEGACY_ID, ChangeField.ID, ChangeField.STATUS, ChangeField.PROJECT, ChangeField.REF, ChangeField.TOPIC, ChangeField.UPDATED, ChangeField.FILE_PART, ChangeField.PATH, ChangeField.OWNER, ChangeField.REVIEWER, ChangeField.COMMIT, ChangeField.TR, ChangeField.LABEL, ChangeField.REVIEWED, ChangeField.COMMIT_MESSAGE, ChangeField.COMMENT, ChangeField.CHANGE, ChangeField.APPROVAL, ChangeField.MERGEABLE);
    public static final ImmutableMap<Integer, Schema<ChangeData>> ALL;

    private static Schema<ChangeData> release(Collection<FieldDef<ChangeData, ?>> fields) {
        return new Schema<ChangeData>(true, fields);
    }

    @SafeVarargs
    private static Schema<ChangeData> release(FieldDef<ChangeData, ?> ... fields) {
        return ChangeSchemas.release(Arrays.asList(fields));
    }

    @SafeVarargs
    private static Schema<ChangeData> developer(FieldDef<ChangeData, ?> ... fields) {
        return new Schema<ChangeData>(false, Arrays.asList(fields));
    }

    public static Schema<ChangeData> get(int version) {
        Schema<ChangeData> schema = ALL.get(version);
        Preconditions.checkArgument(schema != null, "Unrecognized schema version: %s", version);
        return schema;
    }

    public static Schema<ChangeData> getLatest() {
        return (Schema)Iterables.getLast(ALL.values());
    }

    static {
        TreeMap<Integer, Schema> all = Maps.newTreeMap();
        for (Field f : ChangeSchemas.class.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !Schema.class.isAssignableFrom(f.getType())) continue;
            ParameterizedType t = (ParameterizedType)f.getGenericType();
            if (t.getActualTypeArguments()[0] == ChangeData.class) {
                try {
                    Schema schema = (Schema)f.get(null);
                    Preconditions.checkArgument(f.getName().startsWith("V"));
                    schema.setVersion(Integer.parseInt(f.getName().substring(1)));
                    all.put(schema.getVersion(), schema);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ExceptionInInitializerError(e);
                }
                catch (IllegalAccessException e) {
                    throw new ExceptionInInitializerError(e);
                }
            }
            throw new ExceptionInInitializerError("non-ChangeData schema: " + f);
        }
        if (all.isEmpty()) {
            throw new ExceptionInInitializerError("no ChangeSchemas found");
        }
        ALL = ImmutableMap.copyOf(all);
    }
}

