/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.gerrit.server.mail.EmailHeader;
import java.io.UnsupportedEncodingException;

public class Address {
    final String name;
    final String email;
    private static final String MUST_QUOTE_EMAIL = "()<>,;:\\\"[]";
    private static final String MUST_QUOTE_NAME = "()<>,;:\\\"[]@.";

    public static Address parse(String in) {
        int lt = in.indexOf(60);
        int gt = in.indexOf(62);
        int at = in.indexOf("@");
        if (0 <= lt && lt < gt && lt + 1 < at && at + 1 < gt) {
            String email = in.substring(lt + 1, gt).trim();
            String name = in.substring(0, lt).trim();
            return new Address(name.length() > 0 ? name : null, email);
        }
        if (lt < 0 && gt < 0 && 0 < at && at < in.length() - 1) {
            return new Address(in);
        }
        throw new IllegalArgumentException("Invalid email address: " + in);
    }

    public Address(String email) {
        this(null, email);
    }

    public Address(String name, String email) {
        this.name = name;
        this.email = email;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public int hashCode() {
        return this.email.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Address) {
            return this.email.equals(((Address)other).email);
        }
        return false;
    }

    public String toString() {
        try {
            return this.toHeaderString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot encode address", e);
        }
    }

    public String toHeaderString() throws UnsupportedEncodingException {
        if (this.name != null) {
            return Address.quotedPhrase(this.name) + " <" + this.email + ">";
        }
        if (this.isSimple()) {
            return this.email;
        }
        return "<" + this.email + ">";
    }

    private boolean isSimple() {
        for (int i = 0; i < this.email.length(); ++i) {
            char c = this.email.charAt(i);
            if (c > ' ' && '\u007f' > c && MUST_QUOTE_EMAIL.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    private static String quotedPhrase(String name) throws UnsupportedEncodingException {
        if (EmailHeader.needsQuotedPrintable(name)) {
            return EmailHeader.quotedPrintable(name);
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (MUST_QUOTE_NAME.indexOf(c) == -1) continue;
            return Address.wrapInQuotes(name);
        }
        return name;
    }

    private static String wrapInQuotes(String name) {
        StringBuilder r = new StringBuilder(2 + name.length());
        r.append('\"');
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\"' || c == '\\') {
                r.append('\\');
            }
            r.append(c);
        }
        r.append('\"');
        return r.toString();
    }
}

