/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.common.collect.Multimap;
import com.google.gerrit.common.errors.NoSuchAccountException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.notedb.ReviewerState;
import com.google.gwtorm.server.OrmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.revwalk.FooterKey;
import org.eclipse.jgit.revwalk.FooterLine;

public class MailUtil {
    private static final FooterKey REVIEWED_BY = new FooterKey("Reviewed-by");
    private static final FooterKey TESTED_BY = new FooterKey("Tested-by");

    public static MailRecipients getRecipientsFromFooters(AccountResolver accountResolver, PatchSet ps, List<FooterLine> footerLines) throws OrmException {
        MailRecipients recipients = new MailRecipients();
        if (!ps.isDraft()) {
            for (FooterLine footerLine : footerLines) {
                try {
                    if (MailUtil.isReviewer(footerLine)) {
                        recipients.reviewers.add(MailUtil.toAccountId(accountResolver, footerLine.getValue().trim()));
                        continue;
                    }
                    if (!footerLine.matches(FooterKey.CC)) continue;
                    recipients.cc.add(MailUtil.toAccountId(accountResolver, footerLine.getValue().trim()));
                }
                catch (NoSuchAccountException e) {}
            }
        }
        return recipients;
    }

    public static MailRecipients getRecipientsFromReviewers(Multimap<ReviewerState, Account.Id> reviewers) {
        MailRecipients recipients = new MailRecipients();
        recipients.reviewers.addAll(reviewers.get(ReviewerState.REVIEWER));
        recipients.cc.addAll(reviewers.get(ReviewerState.CC));
        return recipients;
    }

    private static Account.Id toAccountId(AccountResolver accountResolver, String nameOrEmail) throws OrmException, NoSuchAccountException {
        Account a = accountResolver.findByNameOrEmail(nameOrEmail);
        if (a == null) {
            throw new NoSuchAccountException("\"" + nameOrEmail + "\" is not registered");
        }
        return a.getId();
    }

    private static boolean isReviewer(FooterLine candidateFooterLine) {
        return candidateFooterLine.matches(FooterKey.SIGNED_OFF_BY) || candidateFooterLine.matches(FooterKey.ACKED_BY) || candidateFooterLine.matches(REVIEWED_BY) || candidateFooterLine.matches(TESTED_BY);
    }

    public static class MailRecipients {
        private final Set<Account.Id> reviewers;
        private final Set<Account.Id> cc;

        public MailRecipients() {
            this.reviewers = new HashSet<Account.Id>();
            this.cc = new HashSet<Account.Id>();
        }

        public MailRecipients(Set<Account.Id> reviewers, Set<Account.Id> cc) {
            this.reviewers = new HashSet<Account.Id>(reviewers);
            this.cc = new HashSet<Account.Id>(cc);
        }

        public void add(MailRecipients recipients) {
            this.reviewers.addAll(recipients.reviewers);
            this.cc.addAll(recipients.cc);
        }

        public void remove(Account.Id toRemove) {
            this.reviewers.remove(toRemove);
            this.cc.remove(toRemove);
        }

        public Set<Account.Id> getReviewers() {
            return Collections.unmodifiableSet(this.reviewers);
        }

        public Set<Account.Id> getCcOnly() {
            HashSet<Account.Id> cc = new HashSet<Account.Id>(this.cc);
            cc.removeAll(this.reviewers);
            return Collections.unmodifiableSet(cc);
        }

        public Set<Account.Id> getAll() {
            HashSet<Account.Id> all = new HashSet<Account.Id>(this.reviewers.size() + this.cc.size());
            all.addAll(this.reviewers);
            all.addAll(this.cc);
            return Collections.unmodifiableSet(all);
        }
    }
}

