/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.common.collect.Iterables;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountProjectWatch;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.EmailArguments;
import com.google.gerrit.server.mail.OutgoingEmail;
import com.google.gerrit.server.mail.ProjectWatch;
import com.google.gerrit.server.mail.RecipientType;
import com.google.gwtorm.server.OrmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NotificationEmail
extends OutgoingEmail {
    private static final Logger log = LoggerFactory.getLogger(NotificationEmail.class);
    protected Project.NameKey project;
    protected Branch.NameKey branch;

    protected NotificationEmail(EmailArguments ea, String mc, Project.NameKey project, Branch.NameKey branch) {
        super(ea, mc);
        this.project = project;
        this.branch = branch;
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        this.setListIdHeader();
    }

    private void setListIdHeader() throws EmailException {
        this.setVHeader("List-Id", "<$email.listId.replace('@', '.')>");
        if (this.getSettingsUrl() != null) {
            this.setVHeader("List-Unsubscribe", "<$email.settingsUrl>");
        }
    }

    public String getListId() throws EmailException {
        return this.velocify("gerrit-$projectName.replace('/', '-')@$email.gerritHost");
    }

    protected void includeWatchers(AccountProjectWatch.NotifyType type) {
        try {
            ProjectWatch.Watchers matching = this.getWatchers(type);
            this.add(RecipientType.TO, matching.to);
            this.add(RecipientType.CC, matching.cc);
            this.add(RecipientType.BCC, matching.bcc);
        }
        catch (OrmException err) {
            log.warn("Cannot BCC watchers for " + (Object)((Object)type), err);
        }
    }

    protected abstract ProjectWatch.Watchers getWatchers(AccountProjectWatch.NotifyType var1) throws OrmException;

    protected void add(RecipientType type, ProjectWatch.Watchers.List list) {
        for (Account.Id user : list.accounts) {
            this.add(type, user);
        }
        for (Address addr : list.emails) {
            this.add(type, addr);
        }
    }

    public String getSshHost() {
        String host = Iterables.getFirst(this.args.sshAddresses, null);
        if (host == null) {
            return null;
        }
        if (host.startsWith("*:")) {
            return this.getGerritHost() + host.substring(1);
        }
        return host;
    }

    @Override
    protected void setupVelocityContext() {
        super.setupVelocityContext();
        this.velocityContext.put("projectName", this.project.get());
        this.velocityContext.put("branch", this.branch);
    }
}

