/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.patch.Text;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSerialization;

public class IntraLineDiffKey
implements Serializable {
    static final long serialVersionUID = 4L;
    private transient boolean ignoreWhitespace;
    private transient ObjectId aId;
    private transient ObjectId bId;
    private transient Text aText;
    private transient Text bText;
    private transient List<Edit> edits;
    private transient Project.NameKey projectKey;
    private transient ObjectId commit;
    private transient String path;

    public IntraLineDiffKey(ObjectId aId, Text aText, ObjectId bId, Text bText, List<Edit> edits, Project.NameKey projectKey, ObjectId commit, String path, boolean ignoreWhitespace) {
        this.aId = aId;
        this.bId = bId;
        this.aText = aText;
        this.bText = bText;
        this.edits = edits;
        this.projectKey = projectKey;
        this.commit = commit;
        this.path = path;
        this.ignoreWhitespace = ignoreWhitespace;
    }

    Text getTextA() {
        return this.aText;
    }

    Text getTextB() {
        return this.bText;
    }

    List<Edit> getEdits() {
        return this.edits;
    }

    public ObjectId getBlobA() {
        return this.aId;
    }

    public ObjectId getBlobB() {
        return this.bId;
    }

    public boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    Project.NameKey getProject() {
        return this.projectKey;
    }

    ObjectId getCommit() {
        return this.commit;
    }

    String getPath() {
        return this.path;
    }

    public int hashCode() {
        int h = 0;
        h = h * 31 + this.aId.hashCode();
        h = h * 31 + this.bId.hashCode();
        h = h * 31 + (this.ignoreWhitespace ? 1 : 0);
        return h;
    }

    public boolean equals(Object o) {
        if (o instanceof IntraLineDiffKey) {
            IntraLineDiffKey k = (IntraLineDiffKey)o;
            return this.aId.equals(k.aId) && this.bId.equals(k.bId) && this.ignoreWhitespace == k.ignoreWhitespace;
        }
        return false;
    }

    public String toString() {
        StringBuilder n = new StringBuilder();
        n.append("IntraLineDiffKey[");
        if (this.projectKey != null) {
            n.append(this.projectKey.get()).append(" ");
        }
        n.append(this.aId.name());
        n.append("..");
        n.append(this.bId.name());
        n.append("]");
        return n.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectIdSerialization.writeNotNull(out, this.aId);
        ObjectIdSerialization.writeNotNull(out, this.bId);
        out.writeBoolean(this.ignoreWhitespace);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.aId = ObjectIdSerialization.readNotNull(in);
        this.bId = ObjectIdSerialization.readNotNull(in);
        this.ignoreWhitespace = in.readBoolean();
    }
}

