/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.gerrit.common.errors.CorruptEntityException;
import com.google.gerrit.common.errors.NoSuchEntityException;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListEntry;
import com.google.gerrit.server.patch.Text;
import java.io.IOException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;

public class PatchFile {
    private final Repository repo;
    private final PatchListEntry entry;
    private final RevTree aTree;
    private final RevTree bTree;
    private Text a;
    private Text b;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchFile(Repository repo, PatchList patchList, String fileName) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.repo = repo;
        this.entry = patchList.get(fileName);
        ObjectReader reader = repo.newObjectReader();
        try {
            RevWalk rw = new RevWalk(reader);
            RevCommit bCommit = rw.parseCommit(patchList.getNewId());
            if ("/COMMIT_MSG".equals(fileName)) {
                this.a = patchList.isAgainstParent() ? Text.EMPTY : Text.forCommit(repo, reader, patchList.getOldId());
                this.b = Text.forCommit(repo, reader, bCommit);
                this.aTree = null;
                this.bTree = null;
            } else {
                if (patchList.getOldId() != null) {
                    this.aTree = rw.parseTree(patchList.getOldId());
                } else {
                    RevCommit p = bCommit.getParent(0);
                    rw.parseHeaders(p);
                    this.aTree = p.getTree();
                }
                this.bTree = bCommit.getTree();
            }
        }
        finally {
            reader.release();
        }
    }

    public String getLine(int file, int line) throws CorruptEntityException, IOException, NoSuchEntityException {
        switch (file) {
            case 0: {
                if (this.a == null) {
                    this.a = this.load(this.aTree, this.entry.getOldName());
                }
                return this.a.getString(line - 1);
            }
            case 1: {
                if (this.b == null) {
                    this.b = this.load(this.bTree, this.entry.getNewName());
                }
                return this.b.getString(line - 1);
            }
        }
        throw new NoSuchEntityException();
    }

    public int getLineCount(int file) throws CorruptEntityException, IOException, NoSuchEntityException {
        switch (file) {
            case 0: {
                if (this.a == null) {
                    this.a = this.load(this.aTree, this.entry.getOldName());
                }
                return this.a.size();
            }
            case 1: {
                if (this.b == null) {
                    this.b = this.load(this.bTree, this.entry.getNewName());
                }
                return this.b.size();
            }
        }
        throw new NoSuchEntityException();
    }

    private Text load(ObjectId tree, String path) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        if (path == null) {
            return Text.EMPTY;
        }
        TreeWalk tw = TreeWalk.forPath(this.repo, path, tree);
        if (tw == null) {
            return Text.EMPTY;
        }
        if (tw.getFileMode(0).getObjectType() != 3) {
            return Text.EMPTY;
        }
        return new Text(this.repo.open(tw.getObjectId(0), 3));
    }
}

