/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.ioutil.BasicSerialization;
import com.google.gerrit.server.patch.PatchListEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSerialization;

public class PatchList
implements Serializable {
    private static final long serialVersionUID = 17L;
    private static final Comparator<PatchListEntry> PATCH_CMP = new Comparator<PatchListEntry>(){

        @Override
        public int compare(PatchListEntry a, PatchListEntry b) {
            return a.getNewName().compareTo(b.getNewName());
        }
    };
    @Nullable
    private transient ObjectId oldId;
    private transient ObjectId newId;
    private transient boolean againstParent;
    private transient int insertions;
    private transient int deletions;
    private transient PatchListEntry[] patches;

    PatchList(@Nullable AnyObjectId oldId, AnyObjectId newId, boolean againstParent, PatchListEntry[] patches) {
        this.oldId = oldId != null ? oldId.copy() : null;
        this.newId = newId.copy();
        this.againstParent = againstParent;
        if (patches.length > 1) {
            Arrays.sort(patches, 1, patches.length, PATCH_CMP);
        }
        for (int i = 1; i < patches.length; ++i) {
            this.insertions += patches[i].getInsertions();
            this.deletions += patches[i].getDeletions();
        }
        this.patches = patches;
    }

    @Nullable
    public ObjectId getOldId() {
        return this.oldId;
    }

    public ObjectId getNewId() {
        return this.newId;
    }

    public List<PatchListEntry> getPatches() {
        return Collections.unmodifiableList(Arrays.asList(this.patches));
    }

    public boolean isAgainstParent() {
        return this.againstParent;
    }

    public int getInsertions() {
        return this.insertions;
    }

    public int getDeletions() {
        return this.deletions;
    }

    public List<Patch> toPatchList(PatchSet.Id setId) {
        ArrayList<Patch> r = new ArrayList<Patch>(this.patches.length);
        for (PatchListEntry e : this.patches) {
            r.add(e.toPatch(setId));
        }
        return r;
    }

    public PatchListEntry get(String fileName) {
        int index = this.search(fileName);
        return 0 <= index ? this.patches[index] : PatchListEntry.empty(fileName);
    }

    private int search(String fileName) {
        if ("/COMMIT_MSG".equals(fileName)) {
            return 0;
        }
        int high = this.patches.length;
        int low = 1;
        while (low < high) {
            int mid = low + high >>> 1;
            int cmp = this.patches[mid].getNewName().compareTo(fileName);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp == 0) {
                return mid;
            }
            high = mid;
        }
        return -(low + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream output) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try (DeflaterOutputStream out = new DeflaterOutputStream(buf);){
            ObjectIdSerialization.writeCanBeNull(out, this.oldId);
            ObjectIdSerialization.writeNotNull(out, this.newId);
            BasicSerialization.writeVarInt32(out, this.againstParent ? 1 : 0);
            BasicSerialization.writeVarInt32(out, this.insertions);
            BasicSerialization.writeVarInt32(out, this.deletions);
            BasicSerialization.writeVarInt32(out, this.patches.length);
            for (PatchListEntry p : this.patches) {
                p.writeTo(out);
            }
        }
        BasicSerialization.writeBytes(output, buf.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream input) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(BasicSerialization.readBytes(input));
        try (InflaterInputStream in = new InflaterInputStream(buf);){
            this.oldId = ObjectIdSerialization.readCanBeNull(in);
            this.newId = ObjectIdSerialization.readNotNull(in);
            this.againstParent = BasicSerialization.readVarInt32(in) != 0;
            this.insertions = BasicSerialization.readVarInt32(in);
            this.deletions = BasicSerialization.readVarInt32(in);
            int cnt = BasicSerialization.readVarInt32(in);
            PatchListEntry[] all = new PatchListEntry[cnt];
            for (int i = 0; i < all.length; ++i) {
                all[i] = PatchListEntry.readFrom(in);
            }
            this.patches = all;
        }
    }
}

