/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.AccountDiffPreference;
import com.google.gerrit.reviewdb.client.CodedEnum;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.ioutil.BasicSerialization;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSerialization;

public class PatchListKey
implements Serializable {
    static final long serialVersionUID = 17L;
    private transient ObjectId oldId;
    private transient ObjectId newId;
    private transient AccountDiffPreference.Whitespace whitespace;
    transient Project.NameKey projectKey;

    public PatchListKey(Project.NameKey pk, AnyObjectId a, AnyObjectId b, AccountDiffPreference.Whitespace ws) {
        this.projectKey = pk;
        this.oldId = a != null ? a.copy() : null;
        this.newId = b.copy();
        this.whitespace = ws;
    }

    @Nullable
    public ObjectId getOldId() {
        return this.oldId;
    }

    public ObjectId getNewId() {
        return this.newId;
    }

    public AccountDiffPreference.Whitespace getWhitespace() {
        return this.whitespace;
    }

    public int hashCode() {
        int h = 0;
        if (this.oldId != null) {
            h = h * 31 + this.oldId.hashCode();
        }
        h = h * 31 + this.newId.hashCode();
        h = h * 31 + this.whitespace.name().hashCode();
        return h;
    }

    public boolean equals(Object o) {
        if (o instanceof PatchListKey) {
            PatchListKey k = (PatchListKey)o;
            return PatchListKey.eq(this.oldId, k.oldId) && PatchListKey.eq(this.newId, k.newId) && this.whitespace == k.whitespace;
        }
        return false;
    }

    public String toString() {
        StringBuilder n = new StringBuilder();
        n.append("PatchListKey[");
        if (this.projectKey != null) {
            n.append(this.projectKey.get());
            n.append(" ");
        }
        n.append(this.oldId != null ? this.oldId.name() : "BASE");
        n.append("..");
        n.append(this.newId.name());
        n.append(" ");
        n.append(this.whitespace.name());
        n.append("]");
        return n.toString();
    }

    private static boolean eq(ObjectId a, ObjectId b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && AnyObjectId.equals(a, b);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectIdSerialization.writeCanBeNull(out, this.oldId);
        ObjectIdSerialization.writeNotNull(out, this.newId);
        BasicSerialization.writeEnum(out, this.whitespace);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.oldId = ObjectIdSerialization.readCanBeNull(in);
        this.newId = ObjectIdSerialization.readNotNull(in);
        this.whitespace = (AccountDiffPreference.Whitespace)BasicSerialization.readEnum((InputStream)in, (CodedEnum[])AccountDiffPreference.Whitespace.values());
    }
}

