/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.gerrit.common.data.CommentDetail;
import com.google.gerrit.common.data.PatchScript;
import com.google.gerrit.prettify.common.EditList;
import com.google.gerrit.prettify.common.SparseFileContent;
import com.google.gerrit.reviewdb.client.AccountDiffPreference;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.FileTypeRegistry;
import com.google.gerrit.server.patch.IntraLineDiff;
import com.google.gerrit.server.patch.IntraLineDiffKey;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListEntry;
import com.google.gerrit.server.patch.Text;
import com.google.inject.Inject;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;

class PatchScriptBuilder {
    static final int MAX_CONTEXT = 5000000;
    static final int BIG_FILE = 9000;
    private static final Comparator<Edit> EDIT_SORT = new Comparator<Edit>(){

        @Override
        public int compare(Edit o1, Edit o2) {
            return o1.getBeginA() - o2.getBeginA();
        }
    };
    private Repository db;
    private Project.NameKey projectKey;
    private ObjectReader reader;
    private Change change;
    private AccountDiffPreference diffPrefs;
    private boolean againstParent;
    private ObjectId aId;
    private ObjectId bId;
    private final Side a = new Side();
    private final Side b = new Side();
    private List<Edit> edits;
    private final FileTypeRegistry registry;
    private final PatchListCache patchListCache;
    private int context;

    @Inject
    PatchScriptBuilder(FileTypeRegistry ftr, PatchListCache plc) {
        this.registry = ftr;
        this.patchListCache = plc;
    }

    void setRepository(Repository r, Project.NameKey projectKey) {
        this.db = r;
        this.projectKey = projectKey;
    }

    void setChange(Change c) {
        this.change = c;
    }

    void setDiffPrefs(AccountDiffPreference dp) {
        this.diffPrefs = dp;
        this.context = this.diffPrefs.getContext();
        if (this.context == -1) {
            this.context = 5000000;
        } else if (this.context > 5000000) {
            this.context = 5000000;
        }
    }

    void setTrees(boolean ap, ObjectId a, ObjectId b) {
        this.againstParent = ap;
        this.aId = a;
        this.bId = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PatchScript toPatchScript(PatchListEntry content, CommentDetail comments, List<Patch> history) throws IOException {
        this.reader = this.db.newObjectReader();
        try {
            PatchScript patchScript = this.build(content, comments, history);
            return patchScript;
        }
        finally {
            this.reader.release();
        }
    }

    private PatchScript build(PatchListEntry content, CommentDetail comments, List<Patch> history) throws IOException {
        boolean intralineDifferenceIsPossible = true;
        boolean intralineFailure = false;
        boolean intralineTimeout = false;
        this.a.path = PatchScriptBuilder.oldName(content);
        this.b.path = PatchScriptBuilder.newName(content);
        this.a.resolve(null, this.aId);
        this.b.resolve(this.a, this.bId);
        this.edits = new ArrayList<Edit>(content.getEdits());
        if (!PatchScriptBuilder.isModify(content)) {
            intralineDifferenceIsPossible = false;
        } else if (this.diffPrefs.isIntralineDifference()) {
            IntraLineDiff d = this.patchListCache.getIntraLineDiff(new IntraLineDiffKey(this.a.id, this.a.src, this.b.id, this.b.src, this.edits, this.projectKey, this.bId, this.b.path, this.diffPrefs.getIgnoreWhitespace() != AccountDiffPreference.Whitespace.IGNORE_NONE));
            if (d != null) {
                switch (d.getStatus()) {
                    case EDIT_LIST: {
                        this.edits = new ArrayList<Edit>(d.getEdits());
                        break;
                    }
                    case DISABLED: {
                        intralineDifferenceIsPossible = false;
                        break;
                    }
                    case ERROR: {
                        intralineDifferenceIsPossible = false;
                        intralineFailure = true;
                        break;
                    }
                    case TIMEOUT: {
                        intralineDifferenceIsPossible = false;
                        intralineTimeout = true;
                    }
                }
            } else {
                intralineDifferenceIsPossible = false;
                intralineFailure = true;
            }
        }
        this.ensureCommentsVisible(comments);
        boolean hugeFile = false;
        if (this.a.mode != FileMode.GITLINK && this.b.mode != FileMode.GITLINK) {
            if (this.a.src == this.b.src && this.a.size() <= this.context && content.getEdits().isEmpty()) {
                for (int i = 0; i < this.a.size(); ++i) {
                    this.a.addLine(i);
                }
                this.edits = new ArrayList<Edit>(1);
                this.edits.add(new Edit(this.a.size(), this.a.size()));
            } else {
                if (9000 < Math.max(this.a.size(), this.b.size())) {
                    hugeFile = true;
                }
                this.context = 5000000;
                this.packContent(this.diffPrefs.getIgnoreWhitespace() != AccountDiffPreference.Whitespace.IGNORE_NONE);
            }
        }
        return new PatchScript(this.change.getKey(), content.getChangeType(), content.getOldName(), content.getNewName(), this.a.fileMode, this.b.fileMode, content.getHeaderLines(), this.diffPrefs, this.a.dst, this.b.dst, this.edits, this.a.displayMethod, this.b.displayMethod, this.a.mimeType.toString(), this.b.mimeType.toString(), comments, history, hugeFile, intralineDifferenceIsPossible, intralineFailure, intralineTimeout);
    }

    private static boolean isModify(PatchListEntry content) {
        switch (content.getChangeType()) {
            case MODIFIED: 
            case COPIED: 
            case RENAMED: {
                return true;
            }
        }
        return false;
    }

    private static String oldName(PatchListEntry entry) {
        switch (entry.getChangeType()) {
            case ADDED: {
                return null;
            }
            case MODIFIED: 
            case DELETED: {
                return entry.getNewName();
            }
        }
        return entry.getOldName();
    }

    private static String newName(PatchListEntry entry) {
        switch (entry.getChangeType()) {
            case DELETED: {
                return null;
            }
        }
        return entry.getNewName();
    }

    private void ensureCommentsVisible(CommentDetail comments) {
        if (comments.getCommentsA().isEmpty() && comments.getCommentsB().isEmpty()) {
            return;
        }
        ArrayList<Edit> empty = new ArrayList<Edit>();
        int lastLine = -1;
        for (PatchLineComment plc : comments.getCommentsA()) {
            int a = plc.getLine();
            if (lastLine == a) continue;
            int b = this.mapA2B(a - 1);
            if (0 <= b) {
                this.safeAdd(empty, new Edit(a - 1, b));
            }
            lastLine = a;
        }
        lastLine = -1;
        for (PatchLineComment plc : comments.getCommentsB()) {
            int b = plc.getLine();
            if (lastLine == b) continue;
            int a = this.mapB2A(b - 1);
            if (0 <= a) {
                this.safeAdd(empty, new Edit(a, b - 1));
            }
            lastLine = b;
        }
        this.edits.addAll(empty);
        Collections.sort(this.edits, EDIT_SORT);
    }

    private void safeAdd(List<Edit> empty, Edit toAdd) {
        int a = toAdd.getBeginA();
        int b = toAdd.getBeginB();
        for (Edit e : this.edits) {
            if (e.getBeginA() <= a && a <= e.getEndA()) {
                return;
            }
            if (e.getBeginB() > b || b > e.getEndB()) continue;
            return;
        }
        empty.add(toAdd);
    }

    private int mapA2B(int a) {
        if (this.edits.isEmpty()) {
            return a;
        }
        for (int i = 0; i < this.edits.size(); ++i) {
            Edit e = this.edits.get(i);
            if (a < e.getBeginA()) {
                if (i == 0) {
                    return a;
                }
                return e.getBeginB() - (e.getBeginA() - a);
            }
            if (e.getBeginA() > a || a > e.getEndA()) continue;
            return -1;
        }
        Edit last = this.edits.get(this.edits.size() - 1);
        return last.getEndB() + (a - last.getEndA());
    }

    private int mapB2A(int b) {
        if (this.edits.isEmpty()) {
            return b;
        }
        for (int i = 0; i < this.edits.size(); ++i) {
            Edit e = this.edits.get(i);
            if (b < e.getBeginB()) {
                if (i == 0) {
                    return b;
                }
                return e.getBeginA() - (e.getBeginB() - b);
            }
            if (e.getBeginB() > b || b > e.getEndB()) continue;
            return -1;
        }
        Edit last = this.edits.get(this.edits.size() - 1);
        return last.getEndA() + (b - last.getEndB());
    }

    private void packContent(boolean ignoredWhitespace) {
        EditList list = new EditList(this.edits, this.context, this.a.size(), this.b.size());
        for (EditList.Hunk hunk : list.getHunks()) {
            while (hunk.next()) {
                if (hunk.isContextLine()) {
                    String lineB;
                    String lineA = this.a.src.getString(hunk.getCurA());
                    this.a.dst.addLine(hunk.getCurA(), lineA);
                    if (ignoredWhitespace && !lineA.equals(lineB = this.b.src.getString(hunk.getCurB()))) {
                        this.b.dst.addLine(hunk.getCurB(), lineB);
                    }
                    hunk.incBoth();
                    continue;
                }
                if (hunk.isDeletedA()) {
                    this.a.addLine(hunk.getCurA());
                    hunk.incA();
                }
                if (!hunk.isInsertedB()) continue;
                this.b.addLine(hunk.getCurB());
                hunk.incB();
            }
        }
    }

    private class Side {
        String path;
        ObjectId id;
        FileMode mode;
        byte[] srcContent;
        Text src;
        MimeType mimeType = MimeUtil2.UNKNOWN_MIME_TYPE;
        PatchScript.DisplayMethod displayMethod = PatchScript.DisplayMethod.DIFF;
        PatchScript.FileMode fileMode = PatchScript.FileMode.FILE;
        final SparseFileContent dst = new SparseFileContent();

        private Side() {
        }

        int size() {
            return this.src != null ? this.src.size() : 0;
        }

        void addLine(int line) {
            this.dst.addLine(line, this.src.getString(line));
        }

        void resolve(Side other, ObjectId within) throws IOException {
            try {
                boolean reuse;
                if ("/COMMIT_MSG".equals(this.path)) {
                    if (PatchScriptBuilder.this.againstParent && (PatchScriptBuilder.this.aId == within || within.equals(PatchScriptBuilder.this.aId))) {
                        this.id = ObjectId.zeroId();
                        this.src = Text.EMPTY;
                        this.srcContent = Text.NO_BYTES;
                        this.mode = FileMode.MISSING;
                        this.displayMethod = PatchScript.DisplayMethod.NONE;
                    } else {
                        this.id = within;
                        this.src = Text.forCommit(PatchScriptBuilder.this.db, PatchScriptBuilder.this.reader, within);
                        this.srcContent = this.src.getContent();
                        if (this.src == Text.EMPTY) {
                            this.mode = FileMode.MISSING;
                            this.displayMethod = PatchScript.DisplayMethod.NONE;
                        } else {
                            this.mode = FileMode.REGULAR_FILE;
                        }
                    }
                    reuse = false;
                } else {
                    TreeWalk tw = this.find(within);
                    this.id = tw != null ? tw.getObjectId(0) : ObjectId.zeroId();
                    this.mode = tw != null ? tw.getFileMode(0) : FileMode.MISSING;
                    boolean bl = reuse = other != null && other.id.equals(this.id) && other.mode == this.mode;
                    this.srcContent = reuse ? other.srcContent : (this.mode.getObjectType() == 3 ? Text.asByteArray(PatchScriptBuilder.this.db.open(this.id, 3)) : Text.NO_BYTES);
                    if (reuse) {
                        this.mimeType = other.mimeType;
                        this.displayMethod = other.displayMethod;
                        this.src = other.src;
                    } else if (this.srcContent.length > 0 && FileMode.SYMLINK != this.mode) {
                        this.mimeType = PatchScriptBuilder.this.registry.getMimeType(this.path, this.srcContent);
                        if ("image".equals(this.mimeType.getMediaType()) && PatchScriptBuilder.this.registry.isSafeInline(this.mimeType)) {
                            this.displayMethod = PatchScript.DisplayMethod.IMG;
                        }
                    }
                }
                if (this.mode == FileMode.MISSING) {
                    this.displayMethod = PatchScript.DisplayMethod.NONE;
                }
                if (!reuse) {
                    this.src = this.srcContent == Text.NO_BYTES ? Text.EMPTY : new Text(this.srcContent);
                }
                if (this.srcContent.length > 0 && this.srcContent[this.srcContent.length - 1] != 10) {
                    this.dst.setMissingNewlineAtEnd(true);
                }
                this.dst.setSize(this.size());
                this.dst.setPath(this.path);
                if (this.mode == FileMode.SYMLINK) {
                    this.fileMode = PatchScript.FileMode.SYMLINK;
                } else if (this.mode == FileMode.GITLINK) {
                    this.fileMode = PatchScript.FileMode.GITLINK;
                }
            }
            catch (IOException err) {
                throw new IOException("Cannot read " + within.name() + ":" + this.path, err);
            }
        }

        private TreeWalk find(ObjectId within) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
            if (this.path == null || within == null) {
                return null;
            }
            RevWalk rw = new RevWalk(PatchScriptBuilder.this.reader);
            RevTree tree = rw.parseTree(within);
            return TreeWalk.forPath(PatchScriptBuilder.this.reader, this.path, tree);
        }
    }
}

