/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.CommentDetail;
import com.google.gerrit.common.data.PatchScript;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountDiffPreference;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountInfoCacheFactory;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.LargeObjectException;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListEntry;
import com.google.gerrit.server.patch.PatchListKey;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.PatchScriptBuilder;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchScriptFactory
implements Callable<PatchScript> {
    private static final Logger log = LoggerFactory.getLogger(PatchScriptFactory.class);
    private final GitRepositoryManager repoManager;
    private final Provider<PatchScriptBuilder> builderFactory;
    private final PatchListCache patchListCache;
    private final ReviewDb db;
    private final AccountInfoCacheFactory.Factory aicFactory;
    private final String fileName;
    @Nullable
    private final PatchSet.Id psa;
    private final PatchSet.Id psb;
    private final AccountDiffPreference diffPrefs;
    private final Change.Id changeId;
    private Change change;
    private Project.NameKey projectKey;
    private ChangeControl control;
    private ObjectId aId;
    private ObjectId bId;
    private List<Patch> history;
    private CommentDetail comments;

    @Inject
    PatchScriptFactory(GitRepositoryManager grm, Provider<PatchScriptBuilder> builderFactory, PatchListCache patchListCache, ReviewDb db, AccountInfoCacheFactory.Factory aicFactory, @Assisted ChangeControl control, @Assisted String fileName, @Assisted(value="patchSetA") @Nullable PatchSet.Id patchSetA, @Assisted(value="patchSetB") PatchSet.Id patchSetB, @Assisted AccountDiffPreference diffPrefs) {
        this.repoManager = grm;
        this.builderFactory = builderFactory;
        this.patchListCache = patchListCache;
        this.db = db;
        this.control = control;
        this.aicFactory = aicFactory;
        this.fileName = fileName;
        this.psa = patchSetA;
        this.psb = patchSetB;
        this.diffPrefs = diffPrefs;
        this.changeId = patchSetB.getParentKey();
    }

    @Override
    public PatchScript call() throws OrmException, NoSuchChangeException, LargeObjectException {
        Repository git;
        this.validatePatchSetId(this.psa);
        this.validatePatchSetId(this.psb);
        this.change = this.control.getChange();
        this.projectKey = this.change.getProject();
        this.aId = this.psa != null ? this.toObjectId(this.db, this.psa) : null;
        this.bId = this.toObjectId(this.db, this.psb);
        if (this.psa != null && !this.control.isPatchVisible(this.db.patchSets().get(this.psa), this.db) || this.psb != null && !this.control.isPatchVisible(this.db.patchSets().get(this.psb), this.db)) {
            throw new NoSuchChangeException(this.changeId);
        }
        try {
            git = this.repoManager.openRepository(this.projectKey);
        }
        catch (RepositoryNotFoundException e) {
            log.error("Repository " + this.projectKey + " not found", e);
            throw new NoSuchChangeException(this.changeId, (Throwable)e);
        }
        catch (IOException e) {
            log.error("Cannot open repository " + this.projectKey, e);
            throw new NoSuchChangeException(this.changeId, (Throwable)e);
        }
        try {
            PatchList list = this.listFor(this.keyFor(this.diffPrefs.getIgnoreWhitespace()));
            PatchScriptBuilder b = this.newBuilder(list, git);
            PatchListEntry content = list.get(this.fileName);
            this.loadCommentsAndHistory(content.getChangeType(), content.getOldName(), content.getNewName());
            PatchScript patchScript = b.toPatchScript(content, this.comments, this.history);
            return patchScript;
        }
        catch (PatchListNotAvailableException e) {
            throw new NoSuchChangeException(this.changeId, (Throwable)e);
        }
        catch (IOException e) {
            log.error("File content unavailable", e);
            throw new NoSuchChangeException(this.changeId, (Throwable)e);
        }
        catch (org.eclipse.jgit.errors.LargeObjectException err) {
            throw new LargeObjectException("File content is too large", err);
        }
        finally {
            git.close();
        }
    }

    private PatchListKey keyFor(AccountDiffPreference.Whitespace whitespace) {
        return new PatchListKey(this.projectKey, this.aId, this.bId, whitespace);
    }

    private PatchList listFor(PatchListKey key) throws PatchListNotAvailableException {
        return this.patchListCache.get(key);
    }

    private PatchScriptBuilder newBuilder(PatchList list, Repository git) {
        AccountDiffPreference dp = new AccountDiffPreference(this.diffPrefs);
        PatchScriptBuilder b = this.builderFactory.get();
        b.setRepository(git, this.projectKey);
        b.setChange(this.change);
        b.setDiffPrefs(dp);
        b.setTrees(list.isAgainstParent(), list.getOldId(), list.getNewId());
        return b;
    }

    private ObjectId toObjectId(ReviewDb db, PatchSet.Id psId) throws OrmException, NoSuchChangeException {
        if (!this.changeId.equals(psId.getParentKey())) {
            throw new NoSuchChangeException(this.changeId);
        }
        PatchSet ps = db.patchSets().get(psId);
        if (ps == null || ps.getRevision() == null || ps.getRevision().get() == null) {
            throw new NoSuchChangeException(this.changeId);
        }
        try {
            return ObjectId.fromString(ps.getRevision().get());
        }
        catch (IllegalArgumentException e) {
            log.error("Patch set " + psId + " has invalid revision");
            throw new NoSuchChangeException(this.changeId, (Throwable)e);
        }
    }

    private void validatePatchSetId(PatchSet.Id psId) throws NoSuchChangeException {
        if (psId != null && !this.changeId.equals(psId.getParentKey())) {
            throw new NoSuchChangeException(this.changeId);
        }
    }

    private void loadCommentsAndHistory(Patch.ChangeType changeType, String oldName, String newName) throws OrmException {
        this.history = new ArrayList<Patch>();
        this.comments = new CommentDetail(this.psa, this.psb);
        HashMap<Patch.Key, Patch> byKey = new HashMap<Patch.Key, Patch>();
        AccountInfoCacheFactory aic = this.aicFactory.create();
        for (PatchSet ps : this.db.patchSets().byChange(this.changeId)) {
            if (!this.control.isPatchVisible(ps, this.db)) continue;
            String name = this.fileName;
            if (this.psa != null) {
                switch (changeType) {
                    case COPIED: 
                    case RENAMED: {
                        if (!ps.getId().equals(this.psa)) break;
                        name = oldName;
                        break;
                    }
                }
            }
            Patch p = new Patch(new Patch.Key(ps.getId(), name));
            this.history.add(p);
            byKey.put(p.getKey(), p);
        }
        switch (changeType) {
            case MODIFIED: 
            case ADDED: {
                this.loadPublished(byKey, aic, newName);
                break;
            }
            case DELETED: {
                this.loadPublished(byKey, aic, newName);
                break;
            }
            case COPIED: 
            case RENAMED: {
                if (this.psa != null) {
                    this.loadPublished(byKey, aic, oldName);
                }
                this.loadPublished(byKey, aic, newName);
                break;
            }
        }
        CurrentUser user = this.control.getCurrentUser();
        if (user.isIdentifiedUser()) {
            Account.Id me = ((IdentifiedUser)user).getAccountId();
            switch (changeType) {
                case MODIFIED: 
                case ADDED: {
                    this.loadDrafts(byKey, aic, me, newName);
                    break;
                }
                case DELETED: {
                    this.loadDrafts(byKey, aic, me, newName);
                    break;
                }
                case COPIED: 
                case RENAMED: {
                    if (this.psa != null) {
                        this.loadDrafts(byKey, aic, me, oldName);
                    }
                    this.loadDrafts(byKey, aic, me, newName);
                    break;
                }
            }
        }
        this.comments.setAccountInfoCache(aic.create());
    }

    private void loadPublished(Map<Patch.Key, Patch> byKey, AccountInfoCacheFactory aic, String file) throws OrmException {
        for (PatchLineComment c : this.db.patchComments().publishedByChangeFile(this.changeId, file)) {
            Patch.Key pKey;
            Patch p;
            if (this.comments.include(c)) {
                aic.want(c.getAuthor());
            }
            if ((p = byKey.get(pKey = c.getKey().getParentKey())) == null) continue;
            p.setCommentCount(p.getCommentCount() + 1);
        }
    }

    private void loadDrafts(Map<Patch.Key, Patch> byKey, AccountInfoCacheFactory aic, Account.Id me, String file) throws OrmException {
        for (PatchLineComment c : this.db.patchComments().draftByChangeFileAuthor(this.changeId, file, me)) {
            Patch.Key pKey;
            Patch p;
            if (this.comments.include(c)) {
                aic.want(me);
            }
            if ((p = byKey.get(pKey = c.getKey().getParentKey())) == null) continue;
            p.setDraftCount(p.getDraftCount() + 1);
        }
    }

    public static interface Factory {
        public PatchScriptFactory create(ChangeControl var1, String var2, @Assisted(value="patchSetA") PatchSet.Id var3, @Assisted(value="patchSetB") PatchSet.Id var4, AccountDiffPreference var5);
    }
}

