/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gerrit.extensions.annotations.Export;
import com.google.gerrit.extensions.annotations.ExtensionPoint;
import com.google.gerrit.extensions.annotations.Listen;
import com.google.gerrit.server.plugins.AutoRegisterUtil;
import com.google.gerrit.server.plugins.InvalidPluginException;
import com.google.gerrit.server.plugins.JarScanner;
import com.google.gerrit.server.plugins.ModuleGenerator;
import com.google.gerrit.server.plugins.PluginGuiceEnvironment;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;

class AutoRegisterModules {
    private final String pluginName;
    private final PluginGuiceEnvironment env;
    private final JarFile jarFile;
    private final ClassLoader classLoader;
    private final ModuleGenerator sshGen;
    private final ModuleGenerator httpGen;
    private Set<Class<?>> sysSingletons;
    private Multimap<TypeLiteral<?>, Class<?>> sysListen;
    Module sysModule;
    Module sshModule;
    Module httpModule;

    AutoRegisterModules(String pluginName, PluginGuiceEnvironment env, JarFile jarFile, ClassLoader classLoader) {
        this.pluginName = pluginName;
        this.env = env;
        this.jarFile = jarFile;
        this.classLoader = classLoader;
        this.sshGen = env.hasSshModule() ? env.newSshModuleGenerator() : null;
        this.httpGen = env.hasHttpModule() ? env.newHttpModuleGenerator() : null;
    }

    AutoRegisterModules discover() throws InvalidPluginException {
        this.sysSingletons = Sets.newHashSet();
        this.sysListen = LinkedListMultimap.create();
        if (this.sshGen != null) {
            this.sshGen.setPluginName(this.pluginName);
        }
        if (this.httpGen != null) {
            this.httpGen.setPluginName(this.pluginName);
        }
        this.scan();
        if (!this.sysSingletons.isEmpty() || !this.sysListen.isEmpty()) {
            this.sysModule = this.makeSystemModule();
        }
        if (this.sshGen != null) {
            this.sshModule = this.sshGen.create();
        }
        if (this.httpGen != null) {
            this.httpModule = this.httpGen.create();
        }
        return this;
    }

    private Module makeSystemModule() {
        return new AbstractModule(){

            @Override
            protected void configure() {
                for (Class clazz : AutoRegisterModules.this.sysSingletons) {
                    this.bind(clazz).in(Scopes.SINGLETON);
                }
                for (Map.Entry entry : AutoRegisterModules.this.sysListen.entries()) {
                    TypeLiteral type = (TypeLiteral)entry.getKey();
                    Class impl = (Class)entry.getValue();
                    Annotation n = AutoRegisterUtil.calculateBindAnnotation(impl);
                    this.bind(type).annotatedWith(n).to(impl);
                }
            }
        };
    }

    private void scan() throws InvalidPluginException {
        Map<Class<? extends Annotation>, Iterable<JarScanner.ExtensionMetaData>> extensions = JarScanner.scan(this.jarFile, this.pluginName, Arrays.asList(Export.class, Listen.class));
        for (JarScanner.ExtensionMetaData export : extensions.get(Export.class)) {
            this.export(export);
        }
        for (JarScanner.ExtensionMetaData listener : extensions.get(Listen.class)) {
            this.listen(listener);
        }
    }

    private void export(JarScanner.ExtensionMetaData def) throws InvalidPluginException {
        Class<?> clazz;
        try {
            clazz = Class.forName(def.getClassName(), false, this.classLoader);
        }
        catch (ClassNotFoundException err) {
            throw new InvalidPluginException(String.format("Cannot load %s with @Export(\"%s\")", def.getClassName(), def.getAnnotationValue()), err);
        }
        Export export = clazz.getAnnotation(Export.class);
        if (export == null) {
            PluginLoader.log.warn(String.format("In plugin %s asm incorrectly parsed %s with @Export(\"%s\")", this.pluginName, clazz.getName(), def.getAnnotationValue()));
            return;
        }
        if (PluginGuiceEnvironment.is("org.apache.sshd.server.Command", clazz)) {
            if (this.sshGen != null) {
                this.sshGen.export(export, clazz);
            }
        } else if (PluginGuiceEnvironment.is("javax.servlet.http.HttpServlet", clazz)) {
            if (this.httpGen != null) {
                this.httpGen.export(export, clazz);
                this.listen(clazz, clazz);
            }
        } else {
            int cnt = this.sysListen.size();
            this.listen(clazz, clazz);
            if (cnt == this.sysListen.size()) {
                throw new InvalidPluginException(String.format("Class %s with @Export(\"%s\") not supported", clazz.getName(), export.value()));
            }
        }
    }

    private void listen(JarScanner.ExtensionMetaData def) throws InvalidPluginException {
        Class<?> clazz;
        try {
            clazz = Class.forName(def.getClassName(), false, this.classLoader);
        }
        catch (ClassNotFoundException err) {
            throw new InvalidPluginException(String.format("Cannot load %s with @Listen", def.getClassName()), err);
        }
        Listen listen = clazz.getAnnotation(Listen.class);
        if (listen != null) {
            this.listen(clazz, clazz);
        } else {
            PluginLoader.log.warn(String.format("In plugin %s asm incorrectly parsed %s with @Listen", this.pluginName, clazz.getName()));
        }
    }

    private void listen(Type type, Class<?> clazz) throws InvalidPluginException {
        while (type != null) {
            Class rawType;
            if (type instanceof ParameterizedType) {
                rawType = (Class)((ParameterizedType)type).getRawType();
            } else if (type instanceof Class) {
                rawType = (Class)type;
            } else {
                return;
            }
            if (rawType.getAnnotation(ExtensionPoint.class) != null) {
                TypeLiteral<?> tl = TypeLiteral.get(type);
                if (this.env.hasDynamicItem(tl)) {
                    this.sysSingletons.add(clazz);
                    this.sysListen.put(tl, clazz);
                    this.httpGen.listen(tl, clazz);
                    this.sshGen.listen(tl, clazz);
                } else if (this.env.hasDynamicSet(tl)) {
                    this.sysSingletons.add(clazz);
                    this.sysListen.put(tl, clazz);
                    this.httpGen.listen(tl, clazz);
                    this.sshGen.listen(tl, clazz);
                } else if (this.env.hasDynamicMap(tl)) {
                    if (clazz.getAnnotation(Export.class) == null) {
                        throw new InvalidPluginException(String.format("Class %s requires @Export(\"name\") annotation for %s", clazz.getName(), rawType.getName()));
                    }
                    this.sysSingletons.add(clazz);
                    this.sysListen.put(tl, clazz);
                    this.httpGen.listen(tl, clazz);
                    this.sshGen.listen(tl, clazz);
                } else {
                    throw new InvalidPluginException(String.format("Cannot register %s, server does not accept %s", clazz.getName(), rawType.getName()));
                }
                return;
            }
            Type[] interfaces = rawType.getGenericInterfaces();
            if (interfaces != null) {
                for (Type i : interfaces) {
                    this.listen(i, clazz);
                }
            }
            type = rawType.getGenericSuperclass();
        }
    }
}

