/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.plugins.ListPlugins;
import com.google.gerrit.server.plugins.PluginInstallException;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.gerrit.server.plugins.PluginResource;
import com.google.inject.Inject;
import java.io.PrintWriter;
import java.io.StringWriter;

@RequiresCapability(value="administrateServer")
class EnablePlugin
implements RestModifyView<PluginResource, Input> {
    private final PluginLoader loader;

    @Inject
    EnablePlugin(PluginLoader loader) {
        this.loader = loader;
    }

    public ListPlugins.PluginInfo apply(PluginResource resource, Input input) throws ResourceConflictException, MethodNotAllowedException {
        if (!this.loader.isRemoteAdminEnabled()) {
            throw new MethodNotAllowedException("remote plugin administration is disabled");
        }
        String name = resource.getName();
        try {
            this.loader.enablePlugins(ImmutableSet.of(name));
        }
        catch (PluginInstallException e) {
            StringWriter buf = new StringWriter();
            buf.write(String.format("cannot enable %s\n", name));
            PrintWriter pw = new PrintWriter(buf);
            e.printStackTrace(pw);
            pw.flush();
            throw new ResourceConflictException(buf.toString());
        }
        return new ListPlugins.PluginInfo(this.loader.get(name));
    }

    static class Input {
        Input() {
        }
    }
}

