/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.server.OutputFormat;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.args4j.Option;

@RequiresCapability(value="viewPlugins")
public class ListPlugins
implements RestReadView<TopLevelResource> {
    private final PluginLoader pluginLoader;
    @Deprecated
    @Option(name="--format", usage="(deprecated) output format")
    private OutputFormat format = OutputFormat.TEXT;
    @Option(name="--all", aliases={"-a"}, usage="List all plugins, including disabled plugins")
    private boolean all;

    @Inject
    protected ListPlugins(PluginLoader pluginLoader) {
        this.pluginLoader = pluginLoader;
    }

    public OutputFormat getFormat() {
        return this.format;
    }

    public ListPlugins setFormat(OutputFormat fmt) {
        this.format = fmt;
        return this;
    }

    @Override
    public Object apply(TopLevelResource resource) throws UnsupportedEncodingException {
        this.format = OutputFormat.JSON;
        return this.display(null);
    }

    public JsonElement display(OutputStream displayOutputStream) throws UnsupportedEncodingException {
        PrintWriter stdout = null;
        if (displayOutputStream != null) {
            try {
                stdout = new PrintWriter(new BufferedWriter(new OutputStreamWriter(displayOutputStream, "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("JVM lacks UTF-8 encoding", e);
            }
        } else if (!this.format.isJson()) {
            throw new IllegalStateException("Text output requires that a display OutputStream is provided.");
        }
        TreeMap<String, PluginInfo> output = Maps.newTreeMap();
        ArrayList<Plugin> plugins = Lists.newArrayList(this.pluginLoader.getPlugins(this.all));
        Collections.sort(plugins, new Comparator<Plugin>(){

            @Override
            public int compare(Plugin a, Plugin b) {
                return a.getName().compareTo(b.getName());
            }
        });
        if (!this.format.isJson()) {
            stdout.format("%-30s %-10s %-8s %s\n", "Name", "Version", "Status", "File");
            stdout.print("-------------------------------------------------------------------------------\n");
        }
        for (Plugin p : plugins) {
            PluginInfo info = new PluginInfo(p);
            if (this.format.isJson()) {
                output.put(p.getName(), info);
                continue;
            }
            stdout.format("%-30s %-10s %-8s %s\n", p.getName(), Strings.nullToEmpty(info.version), p.isDisabled() ? "DISABLED" : "ENABLED", p.getSrcFile().getName());
        }
        if (stdout == null) {
            return OutputFormat.JSON.newGson().toJsonTree(output, new TypeToken<Map<String, Object>>(){}.getType());
        }
        if (this.format.isJson()) {
            this.format.newGson().toJson(output, new TypeToken<Map<String, PluginInfo>>(){}.getType(), stdout);
            stdout.print('\n');
        }
        stdout.flush();
        return null;
    }

    static class PluginInfo {
        final String kind = "gerritcodereview#plugin";
        String id;
        String version;
        String indexUrl;
        Boolean disabled;

        PluginInfo(Plugin p) {
            this.id = Url.encode(p.getName());
            this.version = p.getVersion();
            Boolean bl = this.disabled = p.isDisabled() ? Boolean.valueOf(true) : null;
            if (p.getJarFile() != null) {
                this.indexUrl = String.format("plugins/%s/", p.getName());
            }
        }
    }
}

