/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.project.BranchResource;
import com.google.gerrit.server.project.CreateBranch;
import com.google.gerrit.server.project.ListBranches;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.List;

public class BranchesCollection
implements ChildCollection<ProjectResource, BranchResource>,
AcceptsCreate<ProjectResource> {
    private final DynamicMap<RestView<BranchResource>> views;
    private final Provider<ListBranches> list;
    private final CreateBranch.Factory createBranchFactory;

    @Inject
    BranchesCollection(DynamicMap<RestView<BranchResource>> views, Provider<ListBranches> list, CreateBranch.Factory createBranchFactory) {
        this.views = views;
        this.list = list;
        this.createBranchFactory = createBranchFactory;
    }

    @Override
    public RestView<ProjectResource> list() {
        return this.list.get();
    }

    @Override
    public BranchResource parse(ProjectResource parent, IdString id) throws ResourceNotFoundException, IOException {
        String branchName = id.get();
        if (!branchName.startsWith("refs/") && !branchName.equals("HEAD")) {
            branchName = "refs/heads/" + branchName;
        }
        List<ListBranches.BranchInfo> branches = this.list.get().apply(parent);
        for (ListBranches.BranchInfo b : branches) {
            if (!branchName.equals(b.ref)) continue;
            return new BranchResource(parent.getControl(), b);
        }
        throw new ResourceNotFoundException();
    }

    @Override
    public DynamicMap<RestView<BranchResource>> views() {
        return this.views;
    }

    public CreateBranch create(ProjectResource parent, IdString name) {
        return this.createBranchFactory.create(name.get());
    }
}

