/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gerrit.common.errors.ProjectCreationFailedException;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.project.CreateProjectArgs;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.PerformCreateProject;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectJson;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectsCollection;
import com.google.gerrit.server.project.PutConfig;
import com.google.gerrit.server.validators.ProjectCreationValidationListener;
import com.google.gerrit.server.validators.ValidationException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.ConfigInvalidException;

@RequiresCapability(value="createProject")
public class CreateProject
implements RestModifyView<TopLevelResource, Input> {
    private final PerformCreateProject.Factory createProjectFactory;
    private final Provider<ProjectsCollection> projectsCollection;
    private final Provider<GroupsCollection> groupsCollection;
    private final DynamicSet<ProjectCreationValidationListener> projectCreationValidationListeners;
    private final ProjectJson json;
    private final ProjectControl.GenericFactory projectControlFactory;
    private final Provider<CurrentUser> currentUser;
    private final Provider<PutConfig> putConfig;
    private final String name;

    @Inject
    CreateProject(PerformCreateProject.Factory performCreateProjectFactory, Provider<ProjectsCollection> projectsCollection, Provider<GroupsCollection> groupsCollection, ProjectJson json, DynamicSet<ProjectCreationValidationListener> projectCreationValidationListeners, ProjectControl.GenericFactory projectControlFactory, Provider<CurrentUser> currentUser, Provider<PutConfig> putConfig, @Assisted String name) {
        this.createProjectFactory = performCreateProjectFactory;
        this.projectsCollection = projectsCollection;
        this.groupsCollection = groupsCollection;
        this.projectCreationValidationListeners = projectCreationValidationListeners;
        this.json = json;
        this.projectControlFactory = projectControlFactory;
        this.currentUser = currentUser;
        this.putConfig = putConfig;
        this.name = name;
    }

    public Response<ProjectJson.ProjectInfo> apply(TopLevelResource resource, Input input) throws BadRequestException, UnprocessableEntityException, ResourceConflictException, ProjectCreationFailedException, ResourceNotFoundException, IOException {
        if (input == null) {
            input = new Input();
        }
        if (input.name != null && !this.name.equals(input.name)) {
            throw new BadRequestException("name must match URL");
        }
        CreateProjectArgs args = new CreateProjectArgs();
        args.setProjectName(this.name);
        if (!Strings.isNullOrEmpty(input.parent)) {
            args.newParent = this.projectsCollection.get().parse(input.parent).getControl();
        }
        args.createEmptyCommit = input.createEmptyCommit;
        args.permissionsOnly = input.permissionsOnly;
        args.projectDescription = Strings.emptyToNull(input.description);
        args.submitType = input.submitType;
        args.branch = input.branches;
        if (input.owners != null) {
            ArrayList<AccountGroup.UUID> ownerIds = Lists.newArrayListWithCapacity(input.owners.size());
            for (String owner : input.owners) {
                ownerIds.add(this.groupsCollection.get().parse(owner).getGroupUUID());
            }
            args.ownerIds = ownerIds;
        }
        args.contributorAgreements = Objects.firstNonNull(input.useContributorAgreements, Project.InheritableBoolean.INHERIT);
        args.signedOffBy = Objects.firstNonNull(input.useSignedOffBy, Project.InheritableBoolean.INHERIT);
        args.contentMerge = input.submitType == Project.SubmitType.FAST_FORWARD_ONLY ? Project.InheritableBoolean.FALSE : Objects.firstNonNull(input.useContentMerge, Project.InheritableBoolean.INHERIT);
        args.changeIdRequired = Objects.firstNonNull(input.requireChangeId, Project.InheritableBoolean.INHERIT);
        try {
            args.maxObjectSizeLimit = ProjectConfig.validMaxObjectSizeLimit(input.maxObjectSizeLimit);
        }
        catch (ConfigInvalidException e) {
            throw new BadRequestException(e.getMessage());
        }
        for (ProjectCreationValidationListener l : this.projectCreationValidationListeners) {
            try {
                l.validateNewProject(args);
            }
            catch (ValidationException e) {
                throw new ResourceConflictException(e.getMessage(), e);
            }
        }
        Project p = this.createProjectFactory.create(args).createProject();
        if (input.pluginConfigValues != null) {
            try {
                ProjectControl projectControl = this.projectControlFactory.controlFor(p.getNameKey(), this.currentUser.get());
                PutConfig.Input in = new PutConfig.Input();
                in.pluginConfigValues = input.pluginConfigValues;
                this.putConfig.get().apply(new ProjectResource(projectControl), in);
            }
            catch (NoSuchProjectException e) {
                throw new ResourceNotFoundException(p.getName());
            }
        }
        return Response.created(this.json.format(p));
    }

    public static interface Factory {
        public CreateProject create(String var1);
    }

    public static class Input {
        public String name;
        public String parent;
        public String description;
        public boolean permissionsOnly;
        public boolean createEmptyCommit;
        public Project.SubmitType submitType;
        public List<String> branches;
        public List<String> owners;
        public Project.InheritableBoolean useContributorAgreements;
        public Project.InheritableBoolean useSignedOffBy;
        public Project.InheritableBoolean useContentMerge;
        public Project.InheritableBoolean requireChangeId;
        public String maxObjectSizeLimit;
        public Map<String, Map<String, PutConfig.ConfigValue>> pluginConfigValues;
    }
}

