/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.BranchResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteBranch
implements RestModifyView<BranchResource, Input> {
    private static final Logger log = LoggerFactory.getLogger(DeleteBranch.class);
    private final Provider<IdentifiedUser> identifiedUser;
    private final GitRepositoryManager repoManager;
    private final Provider<ReviewDb> dbProvider;
    private final GitReferenceUpdated referenceUpdated;
    private final ChangeHooks hooks;

    @Inject
    DeleteBranch(Provider<IdentifiedUser> identifiedUser, GitRepositoryManager repoManager, Provider<ReviewDb> dbProvider, GitReferenceUpdated referenceUpdated, ChangeHooks hooks) {
        this.identifiedUser = identifiedUser;
        this.repoManager = repoManager;
        this.dbProvider = dbProvider;
        this.referenceUpdated = referenceUpdated;
        this.hooks = hooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Response<?> apply(BranchResource rsrc, Input input) throws AuthException, ResourceConflictException, OrmException, IOException {
        if (!rsrc.getControl().controlForRef(rsrc.getBranchKey()).canDelete()) {
            throw new AuthException("Cannot delete branch");
        }
        if (this.dbProvider.get().changes().byBranchOpenAll(rsrc.getBranchKey()).iterator().hasNext()) {
            throw new ResourceConflictException("branch " + rsrc.getBranchKey() + " has open changes");
        }
        try (Repository r = this.repoManager.openRepository(rsrc.getNameKey());){
            RefUpdate.Result result;
            RefUpdate u;
            try {
                u = r.updateRef(rsrc.getRef());
                u.setForceUpdate(true);
                result = u.delete();
            }
            catch (IOException e) {
                log.error("Cannot delete " + rsrc.getBranchKey(), e);
                throw e;
            }
            switch (result) {
                case NEW: 
                case NO_CHANGE: 
                case FAST_FORWARD: 
                case FORCED: {
                    this.referenceUpdated.fire(rsrc.getNameKey(), u);
                    this.hooks.doRefUpdatedHook(rsrc.getBranchKey(), u, this.identifiedUser.get().getAccount());
                    return Response.none();
                }
                case REJECTED_CURRENT_BRANCH: {
                    log.warn("Cannot delete " + rsrc.getBranchKey() + ": " + result.name());
                    throw new ResourceConflictException("cannot delete current branch");
                }
                default: {
                    log.error("Cannot delete " + rsrc.getBranchKey() + ": " + result.name());
                    throw new ResourceConflictException("cannot delete branch: " + result.name());
                }
            }
        }
    }

    static class Input {
        Input() {
        }
    }
}

