/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.common.data.GarbageCollectionResult;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.server.git.GarbageCollection;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.LocalDiskRepositoryManager;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;

@RequiresCapability(value="runGC")
public class GarbageCollect
implements RestModifyView<ProjectResource, Input>,
UiAction<ProjectResource> {
    private final boolean canGC;
    private GarbageCollection.Factory garbageCollectionFactory;

    @Inject
    GarbageCollect(GitRepositoryManager repoManager, GarbageCollection.Factory garbageCollectionFactory) {
        this.canGC = repoManager instanceof LocalDiskRepositoryManager;
        this.garbageCollectionFactory = garbageCollectionFactory;
    }

    public BinaryResult apply(final ProjectResource rsrc, final Input input) {
        return new BinaryResult(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeTo(OutputStream out) throws IOException {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)){

                    @Override
                    public void println() {
                        this.write(10);
                    }
                };
                try {
                    GarbageCollectionResult result = GarbageCollect.this.garbageCollectionFactory.create().run(Collections.singletonList(rsrc.getNameKey()), input.showProgress ? writer : null);
                    String msg = "Garbage collection completed successfully.";
                    if (result.hasErrors()) {
                        block8: for (GarbageCollectionResult.Error e : result.getErrors()) {
                            switch (e.getType()) {
                                case REPOSITORY_NOT_FOUND: {
                                    msg = "Error: project \"" + e.getProjectName() + "\" not found.";
                                    continue block8;
                                }
                                case GC_ALREADY_SCHEDULED: {
                                    msg = "Error: garbage collection for project \"" + e.getProjectName() + "\" was already scheduled.";
                                    continue block8;
                                }
                                case GC_FAILED: {
                                    msg = "Error: garbage collection for project \"" + e.getProjectName() + "\" failed.";
                                    continue block8;
                                }
                            }
                            msg = "Error: garbage collection for project \"" + e.getProjectName() + "\" failed: " + (Object)((Object)e.getType()) + ".";
                        }
                    }
                    writer.println(msg);
                }
                finally {
                    writer.flush();
                }
            }
        }.setContentType("text/plain").setCharacterEncoding(StandardCharsets.UTF_8.name()).disableGzip();
    }

    @Override
    public UiAction.Description getDescription(ProjectResource rsrc) {
        return new UiAction.Description().setLabel("Run GC").setTitle("Triggers the Git Garbage Collection for this project.").setVisible(this.canGC);
    }

    public static class Input {
        public boolean showProgress;
    }
}

