/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectJson;
import com.google.gerrit.server.project.ProjectNode;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kohsuke.args4j.Option;

public class ListChildProjects
implements RestReadView<ProjectResource> {
    @Option(name="--recursive", usage="to list child projects recursively")
    private boolean recursive;
    private final ProjectCache projectCache;
    private final AllProjectsName allProjects;
    private final ProjectJson json;
    private final ProjectNode.Factory projectNodeFactory;

    @Inject
    ListChildProjects(ProjectCache projectCache, AllProjectsName allProjects, ProjectJson json, ProjectNode.Factory projectNodeFactory) {
        this.projectCache = projectCache;
        this.allProjects = allProjects;
        this.json = json;
        this.projectNodeFactory = projectNodeFactory;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public List<ProjectJson.ProjectInfo> apply(ProjectResource rsrc) {
        if (this.recursive) {
            return this.getChildProjectsRecursively(rsrc.getNameKey(), rsrc.getControl().getCurrentUser());
        }
        return this.getDirectChildProjects(rsrc.getNameKey());
    }

    private List<ProjectJson.ProjectInfo> getDirectChildProjects(Project.NameKey parent) {
        ArrayList<ProjectJson.ProjectInfo> childProjects = Lists.newArrayList();
        for (Project.NameKey projectName : this.projectCache.all()) {
            ProjectState e = this.projectCache.get(projectName);
            if (e == null || !parent.equals(e.getProject().getParent(this.allProjects))) continue;
            childProjects.add(this.json.format(e.getProject()));
        }
        return childProjects;
    }

    private List<ProjectJson.ProjectInfo> getChildProjectsRecursively(Project.NameKey parent, CurrentUser user) {
        HashMap<Project.NameKey, ProjectNode> projects = Maps.newHashMap();
        for (Project.NameKey name : this.projectCache.all()) {
            ProjectState p = this.projectCache.get(name);
            if (p == null) continue;
            projects.put(name, this.projectNodeFactory.create(p.getProject(), p.controlFor(user).isVisible()));
        }
        for (ProjectNode key : projects.values()) {
            ProjectNode node = (ProjectNode)projects.get(key.getParentName());
            if (node == null) continue;
            node.addChild(key);
        }
        ProjectNode n = (ProjectNode)projects.get(parent);
        if (n != null) {
            return this.getChildProjectsRecursively(n);
        }
        return Collections.emptyList();
    }

    private List<ProjectJson.ProjectInfo> getChildProjectsRecursively(ProjectNode p) {
        ArrayList<ProjectJson.ProjectInfo> allChildren = Lists.newArrayList();
        for (ProjectNode projectNode : p.getChildren()) {
            if (!projectNode.isVisible()) continue;
            allChildren.add(this.json.format(projectNode.getProject()));
            allChildren.addAll(this.getChildProjectsRecursively(projectNode));
        }
        return allChildren;
    }
}

