/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;

@Singleton
public class ProjectCacheClock {
    private volatile long generation;

    @Inject
    public ProjectCacheClock(@GerritServerConfig Config serverConfig) {
        this(ProjectCacheClock.checkFrequency(serverConfig));
    }

    public ProjectCacheClock(long checkFrequencyMillis) {
        if (checkFrequencyMillis == Long.MAX_VALUE) {
            this.generation = 1L;
        } else if (10L < checkFrequencyMillis) {
            this.generation = 1L;
            ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("ProjectCacheClock-%d").setDaemon(true).setPriority(1).build());
            executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    ProjectCacheClock.this.generation = ProjectCacheClock.this.generation + 1L;
                }
            }, checkFrequencyMillis, checkFrequencyMillis, TimeUnit.MILLISECONDS);
        } else {
            this.generation = 0L;
        }
    }

    long read() {
        return this.generation;
    }

    private static long checkFrequency(Config serverConfig) {
        String freq = serverConfig.getString("cache", "projects", "checkFrequency");
        if (freq != null && ("disabled".equalsIgnoreCase(freq) || "off".equalsIgnoreCase(freq))) {
            return Long.MAX_VALUE;
        }
        return TimeUnit.MILLISECONDS.convert(ConfigUtil.getTimeUnit(serverConfig, "cache", "projects", "checkFrequency", 5L, TimeUnit.MINUTES), TimeUnit.MINUTES);
    }
}

