/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import java.util.Map;

public class ProjectJson {
    private final AllProjectsName allProjects;

    @Inject
    ProjectJson(AllProjectsName allProjects) {
        this.allProjects = allProjects;
    }

    public ProjectInfo format(ProjectResource rsrc) {
        return this.format(rsrc.getControl().getProject());
    }

    public ProjectInfo format(Project p) {
        ProjectInfo info = new ProjectInfo();
        info.name = p.getName();
        Project.NameKey parentName = p.getParent(this.allProjects);
        info.parent = parentName != null ? parentName.get() : null;
        info.description = Strings.emptyToNull(p.getDescription());
        info.state = p.getState();
        info.finish();
        return info;
    }

    public static class ProjectInfo {
        public final String kind = "gerritcodereview#project";
        public String id;
        public String name;
        public String parent;
        public String description;
        public Project.State state;
        public Map<String, String> branches;

        void finish() {
            this.id = Url.encode(this.name);
        }
    }
}

