/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.util.TreeFormatter;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.SortedSet;
import java.util.TreeSet;

public class ProjectNode
implements TreeFormatter.TreeNode,
Comparable<ProjectNode> {
    private final AllProjectsName allProjectsName;
    private final Project project;
    private final boolean isVisible;
    private final SortedSet<ProjectNode> children = new TreeSet<ProjectNode>();

    @Inject
    protected ProjectNode(AllProjectsName allProjectsName, @Assisted Project project, @Assisted boolean isVisible) {
        this.allProjectsName = allProjectsName;
        this.project = project;
        this.isVisible = isVisible;
    }

    public Project.NameKey getParentName() {
        return this.project.getParent(this.allProjectsName);
    }

    public boolean isAllProjects() {
        return this.allProjectsName.equals(this.project.getNameKey());
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public String getDisplayName() {
        return this.project.getName();
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    public SortedSet<? extends ProjectNode> getChildren() {
        return this.children;
    }

    public void addChild(ProjectNode child) {
        this.children.add(child);
    }

    @Override
    public int compareTo(ProjectNode o) {
        return this.project.getNameKey().compareTo(o.project.getNameKey());
    }

    public static interface Factory {
        public ProjectNode create(Project var1, boolean var2);
    }
}

