/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

class PutDescription
implements RestModifyView<ProjectResource, Input> {
    private final ProjectCache cache;
    private final MetaDataUpdate.Server updateFactory;
    private final GitRepositoryManager gitMgr;
    private final ChangeHooks hooks;

    @Inject
    PutDescription(ProjectCache cache, MetaDataUpdate.Server updateFactory, ChangeHooks hooks, GitRepositoryManager gitMgr) {
        this.cache = cache;
        this.updateFactory = updateFactory;
        this.hooks = hooks;
        this.gitMgr = gitMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<String> apply(ProjectResource resource, Input input) throws AuthException, ResourceConflictException, ResourceNotFoundException, IOException {
        if (input == null) {
            input = new Input();
        }
        ProjectControl ctl = resource.getControl();
        IdentifiedUser user = (IdentifiedUser)ctl.getCurrentUser();
        if (!ctl.isOwner()) {
            throw new AuthException("not project owner");
        }
        MetaDataUpdate md = this.updateFactory.create(resource.getNameKey());
        try {
            ProjectConfig config = ProjectConfig.read(md);
            Project project = config.getProject();
            project.setDescription(Strings.emptyToNull(input.description));
            String msg = Objects.firstNonNull(Strings.emptyToNull(input.commitMessage), "Updated description.\n");
            if (!msg.endsWith("\n")) {
                msg = msg + "\n";
            }
            md.setAuthor(user);
            md.setMessage(msg);
            ObjectId baseRev = config.getRevision();
            RevCommit commitRev = config.commit(md);
            if (!Objects.equal(baseRev, commitRev)) {
                this.hooks.doRefUpdatedHook(new Branch.NameKey(resource.getNameKey(), "refs/meta/config"), baseRev, commitRev, user.getAccount());
            }
            this.cache.evict(ctl.getProject());
            this.gitMgr.setProjectDescription(resource.getNameKey(), project.getDescription());
            Response<String> response = Strings.isNullOrEmpty(project.getDescription()) ? Response.none() : Response.ok(project.getDescription());
            md.close();
            return response;
        }
        catch (Throwable throwable) {
            try {
                md.close();
                throw throwable;
            }
            catch (RepositoryNotFoundException notFound) {
                throw new ResourceNotFoundException(resource.getName());
            }
            catch (ConfigInvalidException e) {
                throw new ResourceConflictException(String.format("invalid project.config: %s", e.getMessage()));
            }
        }
    }

    static class Input {
        @DefaultInput
        String description;
        String commitMessage;

        Input() {
        }
    }
}

