/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class SuggestParentCandidates {
    private final ProjectControl.Factory projectControlFactory;
    private final ProjectCache projectCache;
    private final AllProjectsName allProject;

    @Inject
    SuggestParentCandidates(ProjectControl.Factory projectControlFactory, ProjectCache projectCache, AllProjectsName allProject) {
        this.projectControlFactory = projectControlFactory;
        this.projectCache = projectCache;
        this.allProject = allProject;
    }

    public List<Project.NameKey> getNameKeys() throws OrmException, NoSuchProjectException {
        List<Project> pList = this.getProjects();
        ArrayList<Project.NameKey> nameKeys = new ArrayList<Project.NameKey>(pList.size());
        for (Project p : pList) {
            nameKeys.add(p.getNameKey());
        }
        return nameKeys;
    }

    public List<Project> getProjects() throws OrmException, NoSuchProjectException {
        TreeSet<Project> projects = new TreeSet<Project>(new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Project.NameKey p : this.projectCache.all()) {
            try {
                ProjectControl pControl;
                ProjectControl control = this.projectControlFactory.controlFor(p);
                Project.NameKey parentK = control.getProject().getParent();
                if (parentK == null || !(pControl = this.projectControlFactory.controlFor(parentK)).isVisible() && !pControl.isOwner()) continue;
                projects.add(pControl.getProject());
            }
            catch (NoSuchProjectException e) {}
        }
        projects.add(this.projectControlFactory.controlFor(this.allProject).getProject());
        return new ArrayList<Project>(projects);
    }

    public static interface Factory {
        public SuggestParentCandidates create();
    }
}

