/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query;

import com.google.gerrit.server.query.OperatorPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.QueryParser;
import com.google.gerrit.server.query.VariablePredicate;
import com.google.gerrit.server.query.WildPatternPredicate;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.antlr.runtime.tree.Tree;

public abstract class QueryBuilder<T> {
    private final Map<String, OperatorFactory> opFactories;

    public static <T, P extends Predicate<T>> P find(Predicate<T> p, Class<P> clazz) {
        if (clazz.isAssignableFrom(p.getClass())) {
            return (P)p;
        }
        for (Predicate<T> c : p.getChildren()) {
            P r = QueryBuilder.find(c, clazz);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public static <T, P extends OperatorPredicate<T>> P find(Predicate<T> p, Class<P> clazz, String name) {
        if (p instanceof OperatorPredicate && ((OperatorPredicate)p).getOperator().equals(name) && clazz.isAssignableFrom(p.getClass())) {
            return (P)((OperatorPredicate)p);
        }
        for (Predicate<T> c : p.getChildren()) {
            P r = QueryBuilder.find(c, clazz, name);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    protected QueryBuilder(Definition<T, ? extends QueryBuilder<T>> def) {
        this.opFactories = ((Definition)def).opFactories;
    }

    public Predicate<T> parse(String query) throws QueryParseException {
        return this.toPredicate(QueryParser.parse(query));
    }

    private Predicate<T> toPredicate(Tree r) throws QueryParseException, IllegalArgumentException {
        switch (r.getType()) {
            case 4: {
                return Predicate.and(this.children(r));
            }
            case 5: {
                return Predicate.or(this.children(r));
            }
            case 6: {
                return Predicate.not(this.toPredicate(this.onlyChildOf(r)));
            }
            case 7: {
                return this.defaultField(this.onlyChildOf(r));
            }
            case 9: {
                return this.operator(r.getText(), this.onlyChildOf(r));
            }
            case 8: {
                Tree val;
                String var = r.getText();
                Tree opTree = this.onlyChildOf(r);
                if (opTree.getType() == 9 && (val = this.onlyChildOf(opTree)).getType() == 10 && "*".equals(val.getText())) {
                    String op = opTree.getText();
                    WildPatternPredicate pat = new WildPatternPredicate(op);
                    return new VariablePredicate(var, pat);
                }
                return new VariablePredicate<T>(var, this.toPredicate(opTree));
            }
        }
        throw QueryBuilder.error("Unsupported operator: " + r);
    }

    private Predicate<T> operator(String name, Tree val) throws QueryParseException {
        switch (val.getType()) {
            case 4: 
            case 5: {
                ArrayList<Predicate<T>> p = new ArrayList<Predicate<T>>(val.getChildCount());
                for (int i = 0; i < val.getChildCount(); ++i) {
                    Tree c = val.getChild(i);
                    if (c.getType() != 7) {
                        throw QueryBuilder.error("Nested operator not expected: " + c);
                    }
                    p.add(this.operator(name, this.onlyChildOf(c)));
                }
                return val.getType() == 4 ? Predicate.and(p) : Predicate.or(p);
            }
            case 10: 
            case 11: {
                if (val.getChildCount() != 0) {
                    throw QueryBuilder.error("Expected no children under: " + val);
                }
                return this.operator(name, val.getText());
            }
        }
        throw QueryBuilder.error("Unsupported node in operator " + name + ": " + val);
    }

    private Predicate<T> operator(String name, String value) throws QueryParseException {
        OperatorFactory f = this.opFactories.get(name);
        if (f == null) {
            throw QueryBuilder.error("Unsupported operator " + name + ":" + value);
        }
        return f.create(this, value);
    }

    private Predicate<T> defaultField(Tree r) throws QueryParseException {
        switch (r.getType()) {
            case 10: 
            case 11: {
                if (r.getChildCount() != 0) {
                    throw QueryBuilder.error("Expected no children under: " + r);
                }
                return this.defaultField(r.getText());
            }
        }
        throw QueryBuilder.error("Unsupported node: " + r);
    }

    protected Predicate<T> defaultField(String value) throws QueryParseException {
        throw QueryBuilder.error("Unsupported query:" + value);
    }

    private Predicate<T>[] children(Tree r) throws QueryParseException, IllegalArgumentException {
        Predicate[] p = new Predicate[r.getChildCount()];
        for (int i = 0; i < p.length; ++i) {
            p[i] = this.toPredicate(r.getChild(i));
        }
        return p;
    }

    private Tree onlyChildOf(Tree r) throws QueryParseException {
        if (r.getChildCount() != 1) {
            throw QueryBuilder.error("Expected exactly one child: " + r);
        }
        return r.getChild(0);
    }

    protected static QueryParseException error(String msg) {
        return new QueryParseException(msg);
    }

    protected static QueryParseException error(String msg, Throwable why) {
        return new QueryParseException(msg, why);
    }

    private static class ReflectionFactory<T, Q extends QueryBuilder<T>>
    implements OperatorFactory<T, Q> {
        private final String name;
        private final Method method;

        ReflectionFactory(String name, Method method) {
            this.name = name;
            this.method = method;
        }

        @Override
        public Predicate<T> create(Q builder, String value) throws QueryParseException {
            try {
                return (Predicate)this.method.invoke(builder, value);
            }
            catch (RuntimeException e) {
                throw QueryBuilder.error("Error in operator " + this.name + ":" + value, e);
            }
            catch (IllegalAccessException e) {
                throw QueryBuilder.error("Error in operator " + this.name + ":" + value, e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof QueryParseException) {
                    throw (QueryParseException)e.getCause();
                }
                throw QueryBuilder.error("Error in operator " + this.name + ":" + value, e.getCause());
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface Operator {
    }

    protected static interface OperatorFactory<T, Q extends QueryBuilder<T>> {
        public Predicate<T> create(Q var1, String var2) throws QueryParseException;
    }

    public static class Definition<T, Q extends QueryBuilder<T>> {
        private final Map<String, OperatorFactory<T, Q>> opFactories = new HashMap<String, OperatorFactory<T, Q>>();

        public Definition(Class<Q> clazz) {
            for (Class<Q> c = clazz; c != QueryBuilder.class; c = c.getSuperclass()) {
                for (Method method : c.getDeclaredMethods()) {
                    String name;
                    if (method.getAnnotation(Operator.class) == null || !Predicate.class.isAssignableFrom(method.getReturnType()) || method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != String.class || (method.getModifiers() & 0x400) != 0 || (method.getModifiers() & 1) != 1 || this.opFactories.containsKey(name = method.getName().toLowerCase())) continue;
                    this.opFactories.put(name, new ReflectionFactory(name, method));
                }
            }
        }
    }
}

