/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query;

import com.google.common.collect.Lists;
import com.google.gerrit.server.query.AndPredicate;
import com.google.gerrit.server.query.NotPredicate;
import com.google.gerrit.server.query.OperatorPredicate;
import com.google.gerrit.server.query.OrPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryBuilder;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.RewritePredicate;
import com.google.gerrit.server.query.VariablePredicate;
import com.google.gerrit.server.query.WildPatternPredicate;
import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class QueryRewriter<T> {
    private final List<RewriteRule<T>> rewriteRules;

    protected QueryRewriter(Definition<T, ? extends QueryRewriter<T>> def) {
        this.rewriteRules = ((Definition)def).rewriteRules;
    }

    public Predicate<T> and(Collection<? extends Predicate<T>> that) {
        return Predicate.and(that);
    }

    public Predicate<T> and(Predicate<T> ... that) {
        return this.and(Arrays.asList(that));
    }

    public Predicate<T> or(Collection<? extends Predicate<T>> that) {
        return Predicate.or(that);
    }

    public Predicate<T> or(Predicate<T> ... that) {
        return this.or(Arrays.asList(that));
    }

    public Predicate<T> not(Predicate<T> that) {
        return Predicate.not(that);
    }

    protected Predicate<T> preRewrite(Predicate<T> in) {
        return in;
    }

    public final Predicate<T> rewrite(Predicate<T> in) {
        in = this.preRewrite(in);
        return this.rewriteImpl(in);
    }

    private Predicate<T> rewriteImpl(Predicate<T> in) {
        Predicate<T> old;
        do {
            if (!(old = in).equals(in = this.rewriteOne(in)) || in.getChildCount() <= 0) continue;
            List<Predicate<T>> n = new ArrayList<Predicate<T>>(in.getChildCount());
            for (Predicate<T> p : in.getChildren()) {
                n.add(this.rewriteImpl(p));
            }
            in = (n = QueryRewriter.removeDuplicates(n)).size() == 1 && (QueryRewriter.isAND(in) || QueryRewriter.isOR(in)) ? n.get(0) : in.copy(n);
        } while (!old.equals(in));
        return this.replaceGenericNodes(in);
    }

    protected Predicate<T> replaceGenericNodes(Predicate<T> in) {
        if (in instanceof NotPredicate) {
            return this.not(this.replaceGenericNodes(in.getChild(0)));
        }
        if (in instanceof AndPredicate) {
            ArrayList<Predicate<T>> n = new ArrayList<Predicate<T>>(in.getChildCount());
            for (Predicate<T> c : in.getChildren()) {
                n.add(this.replaceGenericNodes(c));
            }
            return this.and(n);
        }
        if (in instanceof OrPredicate) {
            ArrayList<Predicate<T>> n = new ArrayList<Predicate<T>>(in.getChildCount());
            for (Predicate<T> c : in.getChildren()) {
                n.add(this.replaceGenericNodes(c));
            }
            return this.or(n);
        }
        return in;
    }

    private Predicate<T> rewriteOne(Predicate<T> input) {
        Predicate<T> best = null;
        for (RewriteRule<T> r : this.rewriteRules) {
            Predicate<T> n = r.rewrite(this, input);
            if (n == null) continue;
            if (!r.useBestCost()) {
                return n;
            }
            if (best != null && n.getCost() >= best.getCost()) continue;
            best = n;
        }
        return best != null ? best : input;
    }

    private MatchResult<T> match(Map<String, Predicate<T>> outVars, Predicate<T> pattern, Predicate<T> actual) {
        if (pattern instanceof VariablePredicate) {
            VariablePredicate v = (VariablePredicate)pattern;
            MatchResult<T> r = this.match(outVars, v.getChild(0), actual);
            if (r.success()) {
                Predicate<T> old = outVars.get(v.getName());
                if (old == null) {
                    outVars.put(v.getName(), actual);
                    return r;
                }
                if (old.equals(actual)) {
                    return r;
                }
                return MatchResult.fail();
            }
            return MatchResult.fail();
        }
        if (QueryRewriter.isAND(pattern) && QueryRewriter.isAND(actual) || QueryRewriter.isOR(pattern) && QueryRewriter.isOR(actual) || QueryRewriter.isNOT(pattern) && QueryRewriter.isNOT(actual)) {
            LinkedList<Predicate<T>> have = QueryRewriter.dup(actual);
            LinkedList extra = new LinkedList();
            for (Predicate<T> pat : pattern.getChildren()) {
                boolean found = false;
                Iterator i = have.iterator();
                while (i.hasNext()) {
                    MatchResult<T> r = this.match(outVars, pat, (Predicate)i.next());
                    if (!r.success()) continue;
                    found = true;
                    i.remove();
                    if (r.extra == null) break;
                    extra.add(r.extra);
                    break;
                }
                if (found) continue;
                return MatchResult.fail();
            }
            have.addAll(extra);
            switch (have.size()) {
                case 0: {
                    return MatchResult.ok();
                }
                case 1: {
                    if (QueryRewriter.isNOT(actual)) {
                        return new MatchResult<T>(actual.copy(have));
                    }
                    return new MatchResult<T>(have.get(0));
                }
            }
            return new MatchResult<T>(actual.copy(have));
        }
        if (pattern.equals(actual)) {
            return MatchResult.ok();
        }
        if (pattern instanceof WildPatternPredicate && actual instanceof OperatorPredicate && ((OperatorPredicate)pattern).getOperator().equals(((OperatorPredicate)actual).getOperator())) {
            return MatchResult.ok();
        }
        return MatchResult.fail();
    }

    private static <T> LinkedList<Predicate<T>> dup(Predicate<T> actual) {
        return new LinkedList<Predicate<T>>(actual.getChildren());
    }

    private static <T> Predicate<T> removeDuplicates(Predicate<T> in) {
        if (in.getChildCount() > 0) {
            List<Predicate<T>> n = QueryRewriter.removeDuplicates(in.getChildren());
            in = n.size() == 1 && (QueryRewriter.isAND(in) || QueryRewriter.isOR(in)) ? n.get(0) : in.copy(n);
        }
        return in;
    }

    private static <T> List<Predicate<T>> removeDuplicates(List<Predicate<T>> n) {
        ArrayList<Predicate<T>> r = new ArrayList<Predicate<T>>();
        for (Predicate<T> p : n) {
            if (r.contains(p)) continue;
            r.add(p);
        }
        return r;
    }

    private static <T> boolean isAND(Predicate<T> p) {
        return p instanceof AndPredicate;
    }

    private static <T> boolean isOR(Predicate<T> p) {
        return p instanceof OrPredicate;
    }

    private static <T> boolean isNOT(Predicate<T> p) {
        return p instanceof NotPredicate;
    }

    private static class MethodRewrite<T>
    implements RewriteRule<T> {
        private final Method method;
        private final Predicate<T> pattern;
        private final String[] argNames;
        private final Class<? extends Predicate<T>>[] argTypes;
        private final boolean useBestCost;

        MethodRewrite(QueryBuilder<T> queryBuilder, String patternText, Method m) {
            Predicate<T> p;
            this.method = m;
            this.useBestCost = m.getAnnotation(NoCostComputation.class) == null;
            try {
                p = queryBuilder.parse(patternText);
            }
            catch (QueryParseException e) {
                throw new RuntimeException("Bad @Rewrite(\"" + patternText + "\")" + " on " + m.toGenericString() + " in " + m.getDeclaringClass() + ": " + e.getMessage(), e);
            }
            if (!Predicate.class.isAssignableFrom(m.getReturnType())) {
                throw new RuntimeException(m.toGenericString() + " in " + m.getDeclaringClass() + " must return " + Predicate.class);
            }
            this.pattern = p;
            this.argNames = new String[this.method.getParameterTypes().length];
            this.argTypes = new Class[this.argNames.length];
            for (int i = 0; i < this.argNames.length; ++i) {
                Named name = null;
                for (Annotation a : this.method.getParameterAnnotations()[i]) {
                    if (!(a instanceof Named)) continue;
                    name = (Named)a;
                    break;
                }
                if (name == null) {
                    throw new RuntimeException("Argument " + (i + 1) + " of " + m.toGenericString() + " in " + m.getDeclaringClass() + " has no @Named annotation");
                }
                if (!Predicate.class.isAssignableFrom(this.method.getParameterTypes()[i])) {
                    throw new RuntimeException("Argument " + (i + 1) + " of " + m.toGenericString() + " in " + m.getDeclaringClass() + " must be of type " + Predicate.class);
                }
                this.argNames[i] = name.value();
                this.argTypes[i] = this.method.getParameterTypes()[i];
            }
        }

        @Override
        public boolean useBestCost() {
            return this.useBestCost;
        }

        @Override
        public Predicate<T> rewrite(QueryRewriter<T> rewriter, Predicate<T> input) {
            Predicate rep;
            HashMap args = new HashMap();
            MatchResult res = ((QueryRewriter)rewriter).match(args, this.pattern, input);
            if (!res.success()) {
                return null;
            }
            Predicate[] argList = new Predicate[this.argNames.length];
            for (int i = 0; i < argList.length; ++i) {
                argList[i] = (Predicate)args.get(this.argNames[i]);
                if (argList[i] == null) {
                    String a = "@Named(\"" + this.argNames[i] + "\")";
                    throw this.error(new IllegalStateException("No value bound for " + a));
                }
                if (this.argTypes[i].isInstance(argList[i])) continue;
                return null;
            }
            try {
                rep = (Predicate)this.method.invoke(rewriter, (Object[])argList);
            }
            catch (IllegalArgumentException e) {
                throw this.error(e);
            }
            catch (IllegalAccessException e) {
                throw this.error(e);
            }
            catch (InvocationTargetException e) {
                throw this.error(e.getCause());
            }
            if (rep instanceof RewritePredicate) {
                ((RewritePredicate)rep).init(this.method.getName(), argList);
            }
            if (res.extra == null) {
                return rep;
            }
            Predicate extra = QueryRewriter.removeDuplicates(res.extra);
            Predicate[] newArgs = new Predicate[]{extra, rep};
            return input.copy(Arrays.asList(newArgs));
        }

        private IllegalArgumentException error(Throwable e) {
            String msg = "Cannot apply " + this.method.getName();
            return new IllegalArgumentException(msg, e);
        }

        @Override
        public int compareTo(RewriteRule<T> in) {
            if (in instanceof MethodRewrite) {
                return this.method.getName().compareTo(((MethodRewrite)in).method.getName());
            }
            return 1;
        }
    }

    protected static interface RewriteRule<T>
    extends Comparable<RewriteRule<T>> {
        public Predicate<T> rewrite(QueryRewriter<T> var1, Predicate<T> var2);

        public boolean useBestCost();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface NoCostComputation {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface Rewrite {
        public String value();
    }

    private static class MatchResult<T> {
        private static final MatchResult<?> FAIL = new MatchResult(null);
        private static final MatchResult<?> OK = new MatchResult(null);
        final Predicate<T> extra;

        static <T> MatchResult<T> fail() {
            return FAIL;
        }

        static <T> MatchResult<T> ok() {
            return OK;
        }

        MatchResult(Predicate<T> extra) {
            this.extra = extra;
        }

        boolean success() {
            return this != FAIL;
        }
    }

    public static class Definition<T, R extends QueryRewriter<T>> {
        private final List<RewriteRule<T>> rewriteRules = Lists.newArrayList();

        public Definition(Class<R> clazz, QueryBuilder<T> qb) {
            for (Class<R> c = clazz; c != QueryRewriter.class; c = c.getSuperclass()) {
                Method[] declared;
                for (Method m : declared = c.getDeclaredMethods()) {
                    Rewrite rp = m.getAnnotation(Rewrite.class);
                    if ((m.getModifiers() & 0x400) == 1024 || (m.getModifiers() & 1) != 1 || rp == null) continue;
                    this.rewriteRules.add(new MethodRewrite<T>(qb, rp.value(), m));
                }
            }
            Collections.sort(this.rewriteRules);
        }
    }
}

