/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.server.index.Schema;
import com.google.gerrit.server.index.TimestampRangePredicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import java.util.Date;

public class AfterPredicate
extends TimestampRangePredicate<ChangeData> {
    private final Date cut;

    AfterPredicate(Schema<ChangeData> schema, String value) throws QueryParseException {
        super(AfterPredicate.updatedField(schema), "before", value);
        this.cut = AfterPredicate.parse(value);
    }

    @Override
    public Date getMinTimestamp() {
        return this.cut;
    }

    @Override
    public Date getMaxTimestamp() {
        return new Date(Long.MAX_VALUE);
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        return cd.change().getLastUpdatedOn().getTime() >= this.cut.getTime();
    }
}

