/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gerrit.server.query.AndPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeDataSource;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.Paginated;
import com.google.gwtorm.server.ListResultSet;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.OrmRuntimeException;
import com.google.gwtorm.server.ResultSet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AndSource
extends AndPredicate<ChangeData>
implements ChangeDataSource {
    private static final Comparator<Predicate<ChangeData>> CMP = new Comparator<Predicate<ChangeData>>(){

        @Override
        public int compare(Predicate<ChangeData> a, Predicate<ChangeData> b) {
            int bi;
            int ai = a instanceof ChangeDataSource ? 0 : 1;
            int cmp = ai - (bi = b instanceof ChangeDataSource ? 0 : 1);
            if (cmp == 0) {
                cmp = a.getCost() - b.getCost();
            }
            if (cmp == 0 && a instanceof ChangeDataSource && b instanceof ChangeDataSource) {
                ChangeDataSource as = (ChangeDataSource)((Object)a);
                ChangeDataSource bs = (ChangeDataSource)((Object)b);
                cmp = as.getCardinality() - bs.getCardinality();
                if (cmp == 0) {
                    cmp = (as.hasChange() ? 0 : 1) - (bs.hasChange() ? 0 : 1);
                }
            }
            return cmp;
        }
    };
    private final int start;
    private int cardinality = -1;

    private static List<Predicate<ChangeData>> sort(Collection<? extends Predicate<ChangeData>> that) {
        ArrayList<Predicate<ChangeData>> r = new ArrayList<Predicate<ChangeData>>(that);
        Collections.sort(r, CMP);
        return r;
    }

    public AndSource(Collection<? extends Predicate<ChangeData>> that) {
        this(that, 0);
    }

    public AndSource(Collection<? extends Predicate<ChangeData>> that, int start) {
        super(AndSource.sort(that));
        Preconditions.checkArgument(start >= 0, "negative start: %s", start);
        this.start = start;
    }

    @Override
    public boolean hasChange() {
        ChangeDataSource source = this.source();
        return source != null && source.hasChange();
    }

    @Override
    public ResultSet<ChangeData> read() throws OrmException {
        try {
            return this.readImpl();
        }
        catch (OrmRuntimeException err) {
            Throwables.propagateIfInstanceOf(err.getCause(), OrmException.class);
            throw new OrmException(err);
        }
    }

    private ResultSet<ChangeData> readImpl() throws OrmException {
        ChangeDataSource source = this.source();
        if (source == null) {
            throw new OrmException("No ChangeDataSource: " + this);
        }
        Predicate pred = (Predicate)((Object)source);
        boolean useSortKey = ChangeQueryBuilder.hasSortKey(pred);
        AbstractCollection r = Lists.newArrayList();
        ChangeData last = null;
        int nextStart = 0;
        boolean skipped = false;
        for (ChangeData data : this.buffer(source, source.read())) {
            if (this.match(data)) {
                r.add(data);
            } else {
                skipped = true;
            }
            last = data;
            ++nextStart;
        }
        if (skipped && last != null && source instanceof Paginated) {
            Paginated p = (Paginated)((Object)source);
            while (skipped && r.size() < p.limit() + this.start) {
                ChangeData lastBeforeRestart = last;
                skipped = false;
                last = null;
                ResultSet<ChangeData> next = useSortKey ? p.restart(lastBeforeRestart) : p.restart(nextStart);
                for (ChangeData data : this.buffer(source, next)) {
                    if (this.match(data)) {
                        r.add(data);
                    } else {
                        skipped = true;
                    }
                    last = data;
                    ++nextStart;
                }
            }
        }
        if (this.start >= r.size()) {
            r = ImmutableList.of();
        } else if (this.start > 0) {
            r = ImmutableList.copyOf(r.subList(this.start, r.size()));
        }
        return new ListResultSet<ChangeData>((List<ChangeData>)((Object)r));
    }

    private Iterable<ChangeData> buffer(ChangeDataSource source, ResultSet<ChangeData> scanner) {
        final boolean loadChange = !source.hasChange();
        return FluentIterable.from(Iterables.partition(scanner, 50)).transformAndConcat(new Function<List<ChangeData>, List<ChangeData>>(){

            @Override
            public List<ChangeData> apply(List<ChangeData> buffer) {
                if (loadChange) {
                    try {
                        ChangeData.ensureChangeLoaded(buffer);
                    }
                    catch (OrmException e) {
                        throw new OrmRuntimeException(e);
                    }
                }
                return buffer;
            }
        });
    }

    private ChangeDataSource source() {
        int minCost = Integer.MAX_VALUE;
        Predicate s = null;
        for (Predicate p : this.getChildren()) {
            if (!(p instanceof ChangeDataSource) || p.getCost() >= minCost) continue;
            s = p;
            minCost = p.getCost();
        }
        return (ChangeDataSource)((Object)s);
    }

    @Override
    public int getCardinality() {
        if (this.cardinality < 0) {
            this.cardinality = Integer.MAX_VALUE;
            for (Predicate p : this.getChildren()) {
                if (!(p instanceof ChangeDataSource)) continue;
                int c = ((ChangeDataSource)((Object)p)).getCardinality();
                this.cardinality = Math.min(this.cardinality, c);
            }
        }
        return this.cardinality;
    }
}

