/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.server.index.Schema;
import com.google.gerrit.server.index.TimestampRangePredicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import java.util.Date;

public class BeforePredicate
extends TimestampRangePredicate<ChangeData> {
    private final Date cut;

    BeforePredicate(Schema<ChangeData> schema, String value) throws QueryParseException {
        super(BeforePredicate.updatedField(schema), "before", value);
        this.cut = BeforePredicate.parse(value);
    }

    @Override
    public Date getMinTimestamp() {
        return new Date(0L);
    }

    @Override
    public Date getMaxTimestamp() {
        return this.cut;
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        return cd.change().getLastUpdatedOn().getTime() <= this.cut.getTime();
    }
}

