/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.query.change.AbstractResultSet;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Provider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class ChangeDataResultSet<T>
extends AbstractResultSet<ChangeData> {
    private final ResultSet<T> source;
    private final boolean unique;

    static ResultSet<ChangeData> change(final ChangeData.Factory factory, final Provider<ReviewDb> db, ResultSet<Change> rs) {
        return new ChangeDataResultSet<Change>(rs, true){

            @Override
            ChangeData convert(Change t) {
                return factory.create((ReviewDb)db.get(), t);
            }
        };
    }

    static ResultSet<ChangeData> patchSet(final ChangeData.Factory factory, final Provider<ReviewDb> db, ResultSet<PatchSet> rs) {
        return new ChangeDataResultSet<PatchSet>(rs, false){

            @Override
            ChangeData convert(PatchSet t) {
                return factory.create((ReviewDb)db.get(), t.getId().getParentKey());
            }
        };
    }

    ChangeDataResultSet(ResultSet<T> source, boolean unique) {
        this.source = source;
        this.unique = unique;
    }

    @Override
    public Iterator<ChangeData> iterator() {
        if (this.unique) {
            return new Iterator<ChangeData>(){
                private final Iterator<T> itr;
                {
                    this.itr = ChangeDataResultSet.this.source.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.itr.hasNext();
                }

                @Override
                public ChangeData next() {
                    return ChangeDataResultSet.this.convert(this.itr.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<ChangeData>(){
            private final Iterator<T> itr;
            private final HashSet<Change.Id> seen;
            private ChangeData next;
            {
                this.itr = ChangeDataResultSet.this.source.iterator();
                this.seen = new HashSet();
            }

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (this.itr.hasNext()) {
                    ChangeData d = ChangeDataResultSet.this.convert(this.itr.next());
                    if (!this.seen.add(d.getId())) continue;
                    this.next = d;
                    return true;
                }
                return false;
            }

            @Override
            public ChangeData next() {
                if (this.hasNext()) {
                    ChangeData r = this.next;
                    this.next = null;
                    return r;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() {
        this.source.close();
    }

    abstract ChangeData convert(T var1);
}

