/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.collect.Lists;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.query.OrPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeDataResultSet;
import com.google.gerrit.server.query.change.ChangeDataSource;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.LegacyChangeIdPredicate;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class IsStarredByPredicate
extends OrPredicate<ChangeData>
implements ChangeDataSource {
    private final ChangeQueryBuilder.Arguments args;
    private final CurrentUser user;

    private static String describe(CurrentUser user) {
        if (user.isIdentifiedUser()) {
            return ((IdentifiedUser)user).getAccountId().toString();
        }
        return user.toString();
    }

    private static List<Predicate<ChangeData>> predicates(ChangeQueryBuilder.Arguments args, Set<Change.Id> ids) {
        ArrayList<Predicate<ChangeData>> r = Lists.newArrayListWithCapacity(ids.size());
        for (Change.Id id : ids) {
            r.add(new LegacyChangeIdPredicate(args, id));
        }
        return r;
    }

    IsStarredByPredicate(ChangeQueryBuilder.Arguments args, CurrentUser user) {
        super(IsStarredByPredicate.predicates(args, user.getStarredChanges()));
        this.args = args;
        this.user = user;
    }

    @Override
    public boolean match(ChangeData object) {
        return this.user.getStarredChanges().contains(object.getId());
    }

    @Override
    public ResultSet<ChangeData> read() throws OrmException {
        return ChangeDataResultSet.change(this.args.changeDataFactory, this.args.db, this.args.db.get().changes().get(this.user.getStarredChanges()));
    }

    @Override
    public boolean hasChange() {
        return true;
    }

    @Override
    public int getCardinality() {
        return 10;
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public String toString() {
        String val = IsStarredByPredicate.describe(this.user);
        if (val.indexOf(32) < 0) {
            return "starredby:" + val;
        }
        return "starredby:\"" + val + "\"";
    }
}

