/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.query.OperatorPredicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.SingleGroupUser;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;

class IsVisibleToPredicate
extends OperatorPredicate<ChangeData> {
    private final Provider<ReviewDb> db;
    private final ChangeControl.GenericFactory changeControl;
    private final CurrentUser user;

    private static String describe(CurrentUser user) {
        if (user.isIdentifiedUser()) {
            return ((IdentifiedUser)user).getAccountId().toString();
        }
        if (user instanceof SingleGroupUser) {
            return "group:" + user.getEffectiveGroups().getKnownGroups().iterator().next().toString();
        }
        return user.toString();
    }

    IsVisibleToPredicate(Provider<ReviewDb> db, ChangeControl.GenericFactory changeControlFactory, CurrentUser user) {
        super("visibleto", IsVisibleToPredicate.describe(user));
        this.db = db;
        this.changeControl = changeControlFactory;
        this.user = user;
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        if (cd.fastIsVisibleTo(this.user)) {
            return true;
        }
        try {
            Change c = cd.change();
            if (c == null) {
                return false;
            }
            ChangeControl cc = this.changeControl.controlFor(c, this.user);
            if (cc.isVisible(this.db.get())) {
                cd.cacheVisibleTo(cc);
                return true;
            }
        }
        catch (NoSuchChangeException noSuchChangeException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int getCost() {
        return 1;
    }
}

