/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gerrit.reviewdb.client.AccountProjectWatch;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.query.AndPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryBuilder;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import java.util.ArrayList;
import java.util.List;

class IsWatchedByPredicate
extends AndPredicate<ChangeData> {
    private final CurrentUser user;

    private static String describe(CurrentUser user) {
        if (user.isIdentifiedUser()) {
            return ((IdentifiedUser)user).getAccountId().toString();
        }
        return user.toString();
    }

    IsWatchedByPredicate(ChangeQueryBuilder.Arguments args, CurrentUser user, boolean checkIsVisible) {
        super(IsWatchedByPredicate.filters(args, user, checkIsVisible));
        this.user = user;
    }

    private static List<Predicate<ChangeData>> filters(ChangeQueryBuilder.Arguments args, CurrentUser user, boolean checkIsVisible) {
        ArrayList r = Lists.newArrayList();
        ChangeQueryBuilder builder = new ChangeQueryBuilder(args, user);
        for (AccountProjectWatch w : user.getNotificationFilters()) {
            Predicate<ChangeData> p;
            Predicate f = null;
            if (w.getFilter() != null) {
                try {
                    f = builder.parse(w.getFilter());
                    if (QueryBuilder.find(f, IsWatchedByPredicate.class) != null) {
                    }
                }
                catch (QueryParseException e) {}
                continue;
            }
            if ((p = w.getProjectNameKey().equals(args.allProjectsName) ? null : builder.project(w.getProjectNameKey().get())) != null && f != null) {
                r.add(IsWatchedByPredicate.and(p, f));
                continue;
            }
            if (p != null) {
                r.add(p);
                continue;
            }
            if (f != null) {
                r.add(f);
                continue;
            }
            r.add(builder.status_open());
        }
        if (r.isEmpty()) {
            return IsWatchedByPredicate.none();
        }
        if (checkIsVisible) {
            return ImmutableList.of(IsWatchedByPredicate.or(r), builder.is_visible());
        }
        return ImmutableList.of(IsWatchedByPredicate.or(r));
    }

    private static List<Predicate<ChangeData>> none() {
        Predicate any = IsWatchedByPredicate.any();
        return ImmutableList.of(IsWatchedByPredicate.not(any));
    }

    @Override
    public int getCost() {
        return 1;
    }

    @Override
    public String toString() {
        String val = IsWatchedByPredicate.describe(this.user);
        if (val.indexOf(32) < 0) {
            return "watchedby:" + val;
        }
        return "watchedby:\"" + val + "\"";
    }
}

