/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeDataSource;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gwtorm.server.ListResultSet;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import java.util.Collections;

class LegacyChangeIdPredicate
extends IndexPredicate<ChangeData>
implements ChangeDataSource {
    private final ChangeQueryBuilder.Arguments args;
    private final Change.Id id;

    LegacyChangeIdPredicate(ChangeQueryBuilder.Arguments args, Change.Id id) {
        super(ChangeField.LEGACY_ID, "change", id.toString());
        this.args = args;
        this.id = id;
    }

    @Override
    public boolean match(ChangeData object) {
        return this.id.equals(object.getId());
    }

    @Override
    public ResultSet<ChangeData> read() throws OrmException {
        Change c = this.args.db.get().changes().get(this.id);
        if (c != null) {
            return new ListResultSet<ChangeData>(Collections.singletonList(this.args.changeDataFactory.create(this.args.db.get(), c)));
        }
        return new ListResultSet<ChangeData>(Collections.emptyList());
    }

    @Override
    public boolean hasChange() {
        return true;
    }

    @Override
    public int getCardinality() {
        return 1;
    }

    @Override
    public int getCost() {
        return 1;
    }
}

