/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.collect.Lists;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.project.ListChildProjects;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectJson;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.OrPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ProjectPredicate;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ParentProjectPredicate
extends OrPredicate<ChangeData> {
    private final String value;

    ParentProjectPredicate(Provider<ReviewDb> dbProvider, ProjectCache projectCache, Provider<ListChildProjects> listChildProjects, Provider<CurrentUser> self, String value) {
        super(ParentProjectPredicate.predicates(dbProvider, projectCache, listChildProjects, self, value));
        this.value = value;
    }

    private static List<Predicate<ChangeData>> predicates(Provider<ReviewDb> dbProvider, ProjectCache projectCache, Provider<ListChildProjects> listChildProjects, Provider<CurrentUser> self, String value) {
        ProjectState projectState = projectCache.get(new Project.NameKey(value));
        if (projectState == null) {
            return Collections.emptyList();
        }
        ArrayList<Predicate<ChangeData>> r = Lists.newArrayList();
        r.add(new ProjectPredicate(projectState.getProject().getName()));
        ListChildProjects children = listChildProjects.get();
        children.setRecursive(true);
        for (ProjectJson.ProjectInfo p : children.apply(new ProjectResource(projectState.controlFor(self.get())))) {
            r.add(new ProjectPredicate(p.name));
        }
        return r;
    }

    @Override
    public String toString() {
        return "parentproject:" + this.value;
    }
}

