/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.RegexPredicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;

class RegexProjectPredicate
extends RegexPredicate<ChangeData> {
    private final RunAutomaton pattern;

    RegexProjectPredicate(String re) {
        super(ChangeField.PROJECT, re);
        if (re.startsWith("^")) {
            re = re.substring(1);
        }
        if (re.endsWith("$") && !re.endsWith("\\$")) {
            re = re.substring(0, re.length() - 1);
        }
        this.pattern = new RunAutomaton(new RegExp(re).toAutomaton());
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        Change change = object.change();
        if (change == null) {
            return false;
        }
        Project.NameKey p = change.getDest().getParentKey();
        return this.pattern.run(p.get());
    }

    @Override
    public int getCost() {
        return 1;
    }
}

